/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.algorithm.FourierTransform;

public class FourierTransformComplex {
    private FImage real;
    private FImage imaginary;
    private boolean centre;

    public FourierTransformComplex(FImage image, boolean centre) {
        this.centre = centre;
        this.process(image);
    }

    public FourierTransformComplex(FImage real, FImage imaginary, boolean centre) {
        this.centre = centre;
        this.real = real;
        this.imaginary = imaginary;
    }

    private void process(FImage image) {
        int cs = image.getCols();
        int rs = image.getRows();
        this.real = new FImage(cs, rs);
        this.imaginary = new FImage(cs, rs);
        FloatFFT_2D fft = new FloatFFT_2D(rs, cs);
        float[][] prepared = FourierTransform.prepareData(image.pixels, rs, cs, this.centre);
        fft.complexForward(prepared);
        for (int y = 0; y < rs; ++y) {
            for (int x = 0; x < cs; ++x) {
                this.real.pixels[y][x] = prepared[y][x * 2];
                this.imaginary.pixels[y][x] = prepared[y][1 + x * 2];
            }
        }
    }

    public FImage inverse() {
        int cs = this.real.getCols();
        int rs = this.real.getRows();
        FloatFFT_2D fft = new FloatFFT_2D(rs, cs);
        float[][] prepared = new float[rs][cs * 2];
        for (int y = 0; y < rs; ++y) {
            for (int x = 0; x < cs; ++x) {
                prepared[y][x * 2] = this.real.pixels[y][x];
                prepared[y][1 + x * 2] = this.imaginary.pixels[y][x];
            }
        }
        fft.complexInverse(prepared, true);
        FImage image = new FImage(cs, rs);
        FourierTransform.unprepareData(prepared, image, this.centre);
        return image;
    }

    public FImage getReal() {
        return this.real;
    }

    public FImage getImaginary() {
        return this.imaginary;
    }

    public boolean isCentre() {
        return this.centre;
    }
}

