/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.algorithm.FilterSupport;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class MinFilter
implements SinglebandImageProcessor<Float, FImage> {
    private Set<Pixel> support;
    private int blockWidth;
    private int blockHeight;

    public MinFilter(Set<Pixel> support) {
        this.support = support;
        if (FilterSupport.isBlockSupport(support)) {
            this.blockWidth = FilterSupport.getSupportWidth(support);
            this.blockHeight = FilterSupport.getSupportHeight(support);
        }
    }

    @Override
    public void processImage(FImage image) {
        if (this.blockWidth >= 1 && this.blockHeight >= 1) {
            MinFilter.minHorizontalSym(image, this.blockWidth);
            MinFilter.minVerticalSym(image, this.blockWidth);
        } else {
            FImage tmpImage = new FImage(image.width, image.height);
            for (int y = 0; y < image.height; ++y) {
                for (int x = 0; x < image.width; ++x) {
                    float min = Float.MAX_VALUE;
                    for (Pixel sp : this.support) {
                        int xx = x + sp.x;
                        int yy = y + sp.y;
                        if (xx < 0 || xx >= image.width || yy < 0 || yy >= image.height) continue;
                        min = Math.min(min, image.pixels[yy][xx]);
                    }
                    tmpImage.pixels[y][x] = min;
                }
            }
            image.internalAssign(tmpImage);
        }
    }

    private static void minHorizontalSym(FImage image, int width) {
        int halfsize = width / 2;
        float[] buffer = new float[image.width + width];
        for (int r = 0; r < image.height; ++r) {
            int i;
            for (i = 0; i < halfsize; ++i) {
                buffer[i] = image.pixels[r][0];
            }
            for (i = 0; i < image.width; ++i) {
                buffer[halfsize + i] = image.pixels[r][i];
            }
            for (i = 0; i < halfsize; ++i) {
                buffer[halfsize + image.width + i] = image.pixels[r][image.width - 1];
            }
            int l = buffer.length - width;
            for (int i2 = 0; i2 < l; ++i2) {
                float min = Float.MAX_VALUE;
                for (int j = 0; j < width; ++j) {
                    min = Math.min(buffer[i2 + j], min);
                }
                image.pixels[r][i2] = min;
            }
        }
    }

    private static void minVerticalSym(FImage image, int width) {
        int halfsize = width / 2;
        float[] buffer = new float[image.height + width];
        for (int c = 0; c < image.width; ++c) {
            int i;
            for (i = 0; i < halfsize; ++i) {
                buffer[i] = image.pixels[0][c];
            }
            for (i = 0; i < image.height; ++i) {
                buffer[halfsize + i] = image.pixels[i][c];
            }
            for (i = 0; i < halfsize; ++i) {
                buffer[halfsize + image.height + i] = image.pixels[image.height - 1][c];
            }
            int l = buffer.length - width;
            for (int i2 = 0; i2 < l; ++i2) {
                float min = Float.MAX_VALUE;
                for (int j = 0; j < width; ++j) {
                    min = Math.min(buffer[i2 + j], min);
                }
                buffer[i2] = min;
            }
            for (int r = 0; r < image.height; ++r) {
                image.pixels[r][c] = buffer[r];
            }
        }
    }
}

