/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.algorithm.FilterSupport;

public class MinMaxAnalyser
implements ImageAnalyser<FImage> {
    private Set<Pixel> support;
    private int blockWidth = -1;
    private int blockHeight = -1;
    public FImage min;
    public FImage max;

    public MinMaxAnalyser(Set<Pixel> support) {
        this.support = support;
        if (FilterSupport.isBlockSupport(support)) {
            this.blockWidth = FilterSupport.getSupportWidth(support);
            this.blockHeight = FilterSupport.getSupportHeight(support);
        }
    }

    @Override
    public void analyseImage(FImage image) {
        this.min = new FImage(image.width, image.height);
        this.max = new FImage(image.width, image.height);
        if (this.blockHeight >= 1 && this.blockWidth >= 1) {
            this.processBlock(image, this.blockWidth, this.blockHeight);
        } else {
            for (int y = 0; y < image.height; ++y) {
                for (int x = 0; x < image.width; ++x) {
                    float minv = Float.MAX_VALUE;
                    float maxv = -3.4028235E38f;
                    for (Pixel sp : this.support) {
                        int xx = x + sp.x;
                        int yy = y + sp.y;
                        if (xx < 0 || xx >= image.width - 1 || yy < 0 || yy >= image.height - 1) continue;
                        minv = Math.min(minv, image.pixels[yy][xx]);
                        maxv = Math.max(maxv, image.pixels[yy][xx]);
                    }
                    this.min.pixels[y][x] = minv;
                    this.max.pixels[y][x] = maxv;
                }
            }
        }
    }

    private void processBlock(FImage image, int width, int height) {
        int halfWidth = width / 2;
        float[] buffer = new float[image.width + width];
        for (int r = 0; r < image.height; ++r) {
            int i;
            for (i = 0; i < halfWidth; ++i) {
                buffer[i] = image.pixels[r][0];
            }
            for (i = 0; i < image.width; ++i) {
                buffer[halfWidth + i] = image.pixels[r][i];
            }
            for (i = 0; i < halfWidth; ++i) {
                buffer[halfWidth + image.width + i] = image.pixels[r][image.width - 1];
            }
            int l = buffer.length - width;
            for (int i2 = 0; i2 < l; ++i2) {
                float min = Float.MAX_VALUE;
                float max = -3.4028235E38f;
                for (int j = 0; j < width; ++j) {
                    min = Math.min(buffer[i2 + j], min);
                    max = Math.max(buffer[i2 + j], max);
                }
                this.min.pixels[r][i2] = min;
                this.max.pixels[r][i2] = max;
            }
        }
        int halfHeight = height / 2;
        float[] minbuffer = new float[this.min.height + height];
        float[] maxbuffer = new float[this.max.height + height];
        for (int c = 0; c < this.min.width; ++c) {
            int i;
            for (i = 0; i < halfHeight; ++i) {
                minbuffer[i] = this.min.pixels[0][c];
                maxbuffer[i] = this.max.pixels[0][c];
            }
            for (i = 0; i < this.min.height; ++i) {
                minbuffer[halfHeight + i] = this.min.pixels[i][c];
                maxbuffer[halfHeight + i] = this.max.pixels[i][c];
            }
            for (i = 0; i < halfHeight; ++i) {
                minbuffer[halfHeight + this.min.height + i] = this.min.pixels[this.min.height - 1][c];
                maxbuffer[halfHeight + this.min.height + i] = this.max.pixels[this.max.height - 1][c];
            }
            int l = minbuffer.length - height;
            for (int i3 = 0; i3 < l; ++i3) {
                float minv = Float.MAX_VALUE;
                float maxv = -3.4028235E38f;
                for (int j = 0; j < height; ++j) {
                    minv = Math.min(minbuffer[i3 + j], minv);
                    maxv = Math.max(maxbuffer[i3 + j], maxv);
                }
                minbuffer[i3] = minv;
                maxbuffer[i3] = maxv;
            }
            for (int r = 0; r < this.min.height; ++r) {
                this.min.pixels[r][c] = minbuffer[r];
                this.max.pixels[r][c] = maxbuffer[r];
            }
        }
    }
}

