/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.math.util.FloatArrayStatsUtils;

public class Disk
extends FConvolution {
    public Disk(int radius) {
        super(Disk.createKernelImage(radius));
    }

    public static FImage createKernelImage(int radius) {
        int sze = 2 * radius + 1;
        FImage f = new FImage(sze, sze);
        int hsz = (sze - 1) / 2;
        int y = -hsz;
        int j = 0;
        while (y < hsz) {
            int x = -hsz;
            int i = 0;
            while (x < hsz) {
                double rad = Math.sqrt(x * x + y * y);
                f.pixels[j][i] = rad < (double)radius ? 1.0f : 0.0f;
                ++x;
                ++i;
            }
            ++y;
            ++j;
        }
        float sum = FloatArrayStatsUtils.sum(f.pixels);
        return f.divideInplace(sum);
    }
}

