/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class FImageConvolveSeparable
implements SinglebandImageProcessor<Float, FImage> {
    float[] hkernel;
    float[] vkernel;

    public FImageConvolveSeparable(float[] hkernel, float[] vkernel) {
        this.hkernel = hkernel;
        this.vkernel = vkernel;
    }

    public FImageConvolveSeparable(float[] kernel) {
        this.hkernel = kernel;
        this.vkernel = kernel;
    }

    @Override
    public void processImage(FImage image) {
        if (this.hkernel != null) {
            FImageConvolveSeparable.convolveHorizontal(image, this.hkernel);
        }
        if (this.vkernel != null) {
            FImageConvolveSeparable.convolveVertical(image, this.vkernel);
        }
    }

    protected static void convolveBuffer(float[] buffer, float[] kernel) {
        int l = buffer.length - kernel.length;
        for (int i = 0; i < l; ++i) {
            float sum = 0.0f;
            int j = 0;
            int jj = kernel.length - 1;
            while (j < kernel.length) {
                sum += buffer[i + j] * kernel[jj];
                ++j;
                --jj;
            }
            buffer[i] = sum;
        }
    }

    public static void convolveHorizontal(FImage image, float[] kernel) {
        int halfsize = kernel.length / 2;
        float[] buffer = new float[image.width + kernel.length];
        for (int r = 0; r < image.height; ++r) {
            int i;
            for (i = 0; i < halfsize; ++i) {
                buffer[i] = image.pixels[r][0];
            }
            for (i = 0; i < image.width; ++i) {
                buffer[halfsize + i] = image.pixels[r][i];
            }
            for (i = 0; i < halfsize; ++i) {
                buffer[halfsize + image.width + i] = image.pixels[r][image.width - 1];
            }
            int l = buffer.length - kernel.length;
            for (int i2 = 0; i2 < l; ++i2) {
                float sum = 0.0f;
                int j = 0;
                int jj = kernel.length - 1;
                while (j < kernel.length) {
                    sum += buffer[i2 + j] * kernel[jj];
                    ++j;
                    --jj;
                }
                buffer[i2] = sum;
            }
            for (int c = 0; c < image.width; ++c) {
                image.pixels[r][c] = buffer[c];
            }
        }
    }

    public static void convolveVertical(FImage image, float[] kernel) {
        int halfsize = kernel.length / 2;
        float[] buffer = new float[image.height + kernel.length];
        for (int c = 0; c < image.width; ++c) {
            int i;
            for (i = 0; i < halfsize; ++i) {
                buffer[i] = image.pixels[0][c];
            }
            for (i = 0; i < image.height; ++i) {
                buffer[halfsize + i] = image.pixels[i][c];
            }
            for (i = 0; i < halfsize; ++i) {
                buffer[halfsize + image.height + i] = image.pixels[image.height - 1][c];
            }
            int l = buffer.length - kernel.length;
            for (int i2 = 0; i2 < l; ++i2) {
                float sum = 0.0f;
                int j = 0;
                int jj = kernel.length - 1;
                while (j < kernel.length) {
                    sum += buffer[i2 + j] * kernel[jj];
                    ++j;
                    --jj;
                }
                buffer[i2] = sum;
            }
            for (int r = 0; r < image.height; ++r) {
                image.pixels[r][c] = buffer[r];
            }
        }
    }

    public static void fastConvolve3(FImage source, FImage dest, float[] kx, float[] ky, float[] buffer) {
        int dst_width = source.width - 2;
        if (kx == null) {
            kx = new float[]{0.0f, 1.0f, 0.0f};
        }
        if (ky == null) {
            ky = new float[]{0.0f, 1.0f, 0.0f};
        }
        if (buffer == null || buffer.length < source.width) {
            buffer = new float[source.width];
        }
        for (int y = 0; y <= source.height - 3; ++y) {
            int x;
            float[] src = source.pixels[y];
            float[] src2 = source.pixels[y + 1];
            float[] src3 = source.pixels[y + 2];
            for (x = 0; x < source.width; ++x) {
                buffer[x] = ky[0] * src[x] + ky[1] * src2[x] + ky[2] * src3[x];
            }
            for (x = 0; x < dst_width; ++x) {
                dest.pixels[y][x] = kx[0] * buffer[x] + kx[1] * buffer[x + 1] + kx[2] * buffer[x + 2];
            }
        }
    }
}

