/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.apache.commons.lang.NotImplementedException;
import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.util.FloatArrayStatsUtils;

public class Gaussian2D
implements SinglebandImageProcessor<Float, FImage> {
    public Gaussian2D(int width, int height, float sigma) {
    }

    public Gaussian2D(int size, float sigma) {
    }

    public static FImage createKernelImage(int size, float sigma) {
        return Gaussian2D.createKernelImage(size, size, sigma);
    }

    public static FImage createKernelImage(int width, int height, float sigma) {
        FImage f = new FImage(width, height);
        int hw = (width - 1) / 2;
        int hh = (height - 1) / 2;
        float sigmasq = sigma * sigma;
        int y = -hh;
        int j = 0;
        while (y <= hh) {
            int x = -hw;
            int i = 0;
            while (x <= hw) {
                int radsqrd = x * x + y * y;
                f.pixels[j][i] = (float)Math.exp((float)(-radsqrd) / (2.0f * sigmasq));
                ++x;
                ++i;
            }
            ++y;
            ++j;
        }
        float sum = FloatArrayStatsUtils.sum(f.pixels);
        return f.divideInplace(sum);
    }

    @Override
    public void processImage(FImage image) {
        throw new NotImplementedException("Not allowed");
    }
}

