/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.math.util.FloatArrayStatsUtils;

public class LaplacianOfGaussian2D
extends FConvolution {
    public LaplacianOfGaussian2D(int width, int height, float sigma) {
        super(LaplacianOfGaussian2D.createKernelImage(width, height, sigma));
    }

    public LaplacianOfGaussian2D(int size, float sigma) {
        super(LaplacianOfGaussian2D.createKernelImage(size, size, sigma));
    }

    public static FImage createKernelImage(int size, float sigma) {
        return LaplacianOfGaussian2D.createKernelImage(size, size, sigma);
    }

    public static FImage createKernelImage(int width, int height, float sigma) {
        FImage f = new FImage(width, height);
        int hw = (width - 1) / 2;
        int hh = (height - 1) / 2;
        float sigmasq = sigma * sigma;
        float sigma4 = sigmasq * sigmasq;
        int y = -hh;
        int j = 0;
        while (y < hh) {
            int x = -hw;
            int i = 0;
            while (x < hw) {
                int radsqrd = x * x + y * y;
                f.pixels[j][i] = (float)(-1.0 / (Math.PI * (double)sigma4) * (double)(1.0f - (float)radsqrd / (2.0f * sigmasq)) * Math.exp((float)(-radsqrd) / (2.0f * sigmasq)));
                ++x;
                ++i;
            }
            ++y;
            ++j;
        }
        return f.subtractInplace(Float.valueOf(FloatArrayStatsUtils.mean(f.pixels)));
    }
}

