/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.SummedAreaTable;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class SumBoxFilter
implements SinglebandImageProcessor<Float, FImage> {
    private int width;
    private int height;

    public SumBoxFilter(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public SumBoxFilter(int dim) {
        this(dim, dim);
    }

    @Override
    public void processImage(FImage image) {
        if (this.height == 1 && this.width == 1) {
            return;
        }
        SummedAreaTable sat = new SummedAreaTable();
        sat.analyseImage(image);
        int hw = this.width / 2;
        int hh = this.height / 2;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                float mean;
                int sx = Math.max(0, x - hw);
                int sy = Math.max(0, y - hh);
                int ex = Math.min(image.width, x + hw + 1);
                int ey = Math.min(image.height, y + hh + 1);
                image.pixels[y][x] = mean = sat.calculateArea(sx, sy, ex, ey);
            }
        }
    }
}

