/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processing.convolution.Gaussian2D;
import org.openimaj.image.processing.convolution.LaplacianOfGaussian2D;
import org.openimaj.image.processing.convolution.filterbank.FilterBank;
import org.openimaj.image.processing.convolution.filterbank.LeungMalikFilterBank;

public class RootFilterSetFilterBank
extends FilterBank {
    protected static final float[] SCALES = new float[]{1.0f, 2.0f, 4.0f};
    protected static final int NUM_ORIENTATIONS = 6;

    public RootFilterSetFilterBank() {
        this(49);
    }

    public RootFilterSetFilterBank(int size) {
        super(RootFilterSetFilterBank.makeFilters(size));
    }

    protected static FConvolution[] makeFilters(int size) {
        int numRotInvariants = 2;
        int numBar = SCALES.length * 6;
        int numEdge = SCALES.length * 6;
        int numFilters = numBar + numEdge + 2;
        FConvolution[] F = new FConvolution[numFilters];
        int count = 0;
        for (float scale : SCALES) {
            for (int orient = 0; orient < 6; ++orient) {
                float angle = (float)(Math.PI * (double)orient / 6.0);
                F[count] = new FConvolution(LeungMalikFilterBank.makeFilter(scale, 0, 1, angle, size));
                F[count + numEdge] = new FConvolution(LeungMalikFilterBank.makeFilter(scale, 0, 2, angle, size));
                ++count;
            }
        }
        F[numBar + numEdge] = new FConvolution(Gaussian2D.createKernelImage(size, 10.0f));
        F[numBar + numEdge + 1] = new FConvolution(LeungMalikFilterBank.normalise(LaplacianOfGaussian2D.createKernelImage(size, 10.0f)));
        return F;
    }
}

