/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import java.util.ArrayDeque;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.histogram.HistogramAnalyser;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.convolution.FSobel;
import org.openimaj.image.processing.edges.NonMaximumSuppressionTangent;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.statistics.distribution.Histogram;

public class CannyEdgeDetector
implements SinglebandImageProcessor<Float, FImage> {
    static final float threshRatio = 0.4f;
    float lowThresh = -1.0f;
    float highThresh = -1.0f;
    float sigma = 1.0f;

    public CannyEdgeDetector() {
    }

    public CannyEdgeDetector(float sigma) {
        this.sigma = sigma;
    }

    public CannyEdgeDetector(float lowThresh, float highThresh, float sigma) {
        if (lowThresh < 0.0f || lowThresh > 1.0f) {
            throw new IllegalArgumentException("Low threshold must be between 0 and 1");
        }
        if (highThresh < 0.0f || highThresh > 1.0f) {
            throw new IllegalArgumentException("High threshold must be between 0 and 1");
        }
        if (highThresh < lowThresh) {
            throw new IllegalArgumentException("High threshold must be bigger than the lower threshold");
        }
        if (sigma < 0.0f) {
            throw new IllegalArgumentException("Sigma must be > 0");
        }
        this.lowThresh = lowThresh;
        this.highThresh = highThresh;
        this.sigma = sigma;
    }

    float computeHighThreshold(FImage magnitudes) {
        Histogram hist = HistogramAnalyser.getHistogram(magnitudes, 64);
        float cumSum = 0.0f;
        for (int i = 0; i < 64; ++i) {
            if ((double)cumSum > 0.7 * (double)magnitudes.width * (double)magnitudes.height) {
                return (float)i / 64.0f;
            }
            cumSum = (float)((double)cumSum + ((double[])hist.values)[i]);
        }
        return 1.0f;
    }

    @Override
    public void processImage(FImage image) {
        this.processImage(image, new FSobel(this.sigma));
    }

    public void processImage(FImage image, FSobel sobel) {
        image.analyseWith(sobel);
        this.processImage(image, sobel.dx, sobel.dy);
    }

    public void processImage(FImage output, FImage dx, FImage dy) {
        FImage tmpMags = new FImage(dx.width, dx.height);
        FImage magnitudes = NonMaximumSuppressionTangent.computeSuppressed(dx, dy, tmpMags);
        magnitudes.normalise();
        float low = this.lowThresh;
        float high = this.highThresh;
        if (high < 0.0f) {
            high = this.computeHighThreshold(tmpMags);
            low = 0.4f * high;
        }
        this.thresholdingTracker(magnitudes, output, low, high);
    }

    private void thresholdingTracker(FImage magnitude, FImage output, float low, float high) {
        output.zero();
        ArrayDeque<Pixel> candidates = new ArrayDeque<Pixel>();
        for (int y = 0; y < magnitude.height; ++y) {
            for (int x = 0; x < magnitude.width; ++x) {
                if (!(magnitude.pixels[y][x] >= high) || output.pixels[y][x] == 1.0f) continue;
                candidates.add(new Pixel(x, y));
                while (!candidates.isEmpty()) {
                    Pixel current = (Pixel)candidates.pollFirst();
                    if (current.x < 0 || current.x > magnitude.width || current.y < 0 || current.y > magnitude.height || output.pixels[current.y][current.x] == 1.0f || magnitude.pixels[current.y][current.x] < low) continue;
                    output.pixels[current.y][current.x] = 1.0f;
                    candidates.add(new Pixel(x - 1, y - 1));
                    candidates.add(new Pixel(x, y - 1));
                    candidates.add(new Pixel(x + 1, y - 1));
                    candidates.add(new Pixel(x - 1, y));
                    candidates.add(new Pixel(x + 1, y));
                    candidates.add(new Pixel(x - 1, y + 1));
                    candidates.add(new Pixel(x, y + 1));
                    candidates.add(new Pixel(x + 1, y + 1));
                }
            }
        }
    }
}

