/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import org.openimaj.image.FImage;
import org.openimaj.image.combiner.ImageCombiner;

public class NonMaximumSuppression
implements ImageCombiner<FImage, FImage, FImage> {
    public static FImage computeSuppressed(FImage mag, FImage ori) {
        int height = mag.getHeight();
        int width = mag.getWidth();
        FImage suppressed = new FImage(width, height);
        float p8 = 0.3926991f;
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                if (!(mag.pixels[y][x] > 0.0f)) continue;
                float t = (float)((double)ori.pixels[y][x] - 1.5707963267948966);
                if (t >= -p8 && t <= p8 || t <= -7.0f * p8 || t >= 7.0f * p8) {
                    if (!(mag.pixels[y][x] > mag.pixels[y + 1][x]) || !(mag.pixels[y][x] >= mag.pixels[y - 1][x])) continue;
                    suppressed.pixels[y][x] = mag.pixels[y][x];
                    continue;
                }
                if (t >= 3.0f * p8 && t <= 5.0f * p8 || t >= -5.0f * p8 && t <= -3.0f * p8) {
                    if (!(mag.pixels[y][x] >= mag.pixels[y][x + 1]) || !(mag.pixels[y][x] > mag.pixels[y][x - 1])) continue;
                    suppressed.pixels[y][x] = mag.pixels[y][x];
                    continue;
                }
                if (t >= p8 && t <= 3.0f * p8 || t >= -7.0f * p8 && t <= -5.0f * p8) {
                    if (!(mag.pixels[y][x] > mag.pixels[y + 1][x - 1]) || !(mag.pixels[y][x] >= mag.pixels[y - 1][x + 1])) continue;
                    suppressed.pixels[y][x] = mag.pixels[y][x];
                    continue;
                }
                if (!(mag.pixels[y][x] > mag.pixels[y - 1][x - 1]) || !(mag.pixels[y][x] >= mag.pixels[y + 1][x + 1])) continue;
                suppressed.pixels[y][x] = mag.pixels[y][x];
            }
        }
        return suppressed;
    }

    @Override
    public FImage combine(FImage mag, FImage ori) {
        return NonMaximumSuppression.computeSuppressed(mag, ori);
    }
}

