/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.extraction;

import Jama.Matrix;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class OrientedPolygonExtractionProcessor
implements ImageProcessor<FImage> {
    private final float background;
    private final Ellipse polygonEllipse;

    public OrientedPolygonExtractionProcessor(Polygon polygon, float background) {
        this.polygonEllipse = polygon.toEllipse();
        this.background = background;
    }

    @Override
    public void processImage(FImage image) {
        image.internalAssign(this.orientedBoundingBoxProjection(image));
    }

    private FImage orientedBoundingBoxProjection(FImage image) {
        ProjectionProcessor<Float, FImage> pp = new ProjectionProcessor<Float, FImage>();
        Matrix trans = Matrix.identity(3, 3);
        trans = trans.times(TransformUtilities.rotationMatrix(-this.polygonEllipse.getRotation()));
        trans = trans.times(TransformUtilities.translateToPointMatrix(this.polygonEllipse.calculateCentroid(), new Point2dImpl(0.0f, 0.0f)));
        pp.setMatrix(trans);
        pp.accumulate(image);
        return (FImage)pp.performProjection((int)(-this.polygonEllipse.getMajor()), (int)this.polygonEllipse.getMajor(), (int)(-this.polygonEllipse.getMinor()), (int)this.polygonEllipse.getMinor(), Float.valueOf(this.background));
    }
}

