/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.mask;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;

public class MatteGenerator {
    public static FImage generateMatte(MBFImage image, int band, MatteType type, Object ... args) {
        return MatteGenerator.generateMatte((FImage)image.getBand(band), type, args);
    }

    public static FImage generateMatte(FImage image, MatteType type, Object ... args) {
        type.generateMatte(image, args);
        return image;
    }

    public static enum MatteType {
        LINEAR_VERTICAL_GRADIENT{

            @Override
            public void generateMatte(FImage img, Object ... args) {
                boolean whiteAtTop = false;
                if (args.length == 0 || args[0] instanceof Boolean && !((Boolean)args[0]).booleanValue()) {
                    whiteAtTop = true;
                }
                double g = whiteAtTop ? 1 : 0;
                double scalar = whiteAtTop ? -1.0 / (double)img.getHeight() : 1.0 / (double)img.getHeight();
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        img.pixels[y][x] = (float)(g + (double)y * scalar);
                    }
                }
            }
        }
        ,
        LINEAR_HORIZONTAL_GRADIENT{

            @Override
            public void generateMatte(FImage img, Object ... args) {
                boolean whiteAtLeft = false;
                if (args.length == 0 || args[0] instanceof Boolean && !((Boolean)args[0]).booleanValue()) {
                    whiteAtLeft = true;
                }
                double g = whiteAtLeft ? 1 : 0;
                double scalar = whiteAtLeft ? -1.0 / (double)img.getWidth() : 1.0 / (double)img.getWidth();
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        img.pixels[y][x] = (float)(g + (double)x * scalar);
                    }
                }
            }
        }
        ,
        RADIAL_GRADIENT{

            @Override
            public void generateMatte(FImage img, Object ... args) {
                boolean whiteInCentre = false;
                if (args.length > 0 && args[0] instanceof Boolean && ((Boolean)args[0]).booleanValue()) {
                    whiteInCentre = true;
                }
                int cx = img.getWidth() / 2;
                int cy = img.getHeight() / 2;
                int maxDist = Math.max(Math.max(img.getWidth() - cx, cx), Math.max(img.getHeight() - cy, cy));
                double scale = maxDist;
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        img.pixels[y][x] = whiteInCentre ? 1.0f - (float)this.distanceFromCentre(cx, cy, x, y, scale) : (float)this.distanceFromCentre(cx, cy, x, y, scale);
                    }
                }
            }

            private double distanceFromCentre(int cx, int cy, int x, int y, double scale) {
                double b = cx - x;
                double c = cy - y;
                double v = Math.abs(Math.sqrt(b * b + c * c)) / scale;
                if (v > 1.0) {
                    v = 1.0;
                }
                if (v < 0.0) {
                    v = 0.0;
                }
                return v;
            }
        }
        ,
        ANGLED_LINEAR_GRADIENT{

            @Override
            public void generateMatte(FImage img, Object ... args) {
                double angle = 0.0;
                double lx = 0.0;
                double ly = 0.0;
                if (args.length > 0 && args[0] instanceof Double) {
                    angle = (Double)args[0];
                }
                if (args.length > 1 && args[1] instanceof Double) {
                    lx = (Double)args[1];
                }
                if (args.length > 2 && args[2] instanceof Double) {
                    ly = (Double)args[2];
                }
                double scalar = Math.max(Math.max((double)img.getWidth() - lx, lx), Math.max((double)img.getHeight() - ly, ly));
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        img.pixels[y][x] = (float)this.distanceFromAxis(lx, ly, angle, x, y, scalar);
                    }
                }
            }

            private double distanceFromAxis(double lx, double ly, double angle, double x, double y, double scalar) {
                Line2d line = Line2d.lineFromRotation((int)lx, (int)ly, angle, 1);
                Point2d A = line.begin;
                Point2d B = line.end;
                Point2dImpl P = new Point2dImpl((float)x, (float)y);
                double normalLength = Math.hypot(B.getX() - A.getX(), B.getY() - A.getY());
                double grad = (double)Math.abs((P.x - A.getX()) * (B.getY() - A.getY()) - (P.y - A.getY()) * (B.getX() - A.getX())) / normalLength / scalar;
                if (grad < 0.0) {
                    grad = 0.0;
                }
                if (grad > 1.0) {
                    grad = 1.0;
                }
                return grad;
            }
        };


        public abstract void generateMatte(FImage var1, Object ... var2);
    }
}

