/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.ImageInterpolation;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class BicubicInterpolation
implements SinglebandImageProcessor<Float, FImage> {
    protected int width;
    protected int height;
    protected float scale;

    public BicubicInterpolation(int width, int height, float scale) {
        this.width = width;
        this.height = height;
        this.scale = scale;
    }

    @Override
    public void processImage(FImage image) {
        FImage newimage = image.newInstance(this.width, this.height);
        float[][] working = new float[4][4];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                newimage.pixels[y][x] = ImageInterpolation.InterpolationType.BICUBIC.interpolate((float)x * this.scale, (float)y * this.scale, image, working);
            }
        }
        image.internalAssign(newimage);
    }
}

