/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class BilinearInterpolation
implements SinglebandImageProcessor<Float, FImage> {
    protected int width;
    protected int height;
    protected float scale;

    public BilinearInterpolation(int width, int height, float scale) {
        this.width = width;
        this.height = height;
        this.scale = scale;
    }

    @Override
    public void processImage(FImage image) {
        FImage newimage = image.newInstance(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                newimage.pixels[y][x] = image.getPixelInterp((float)x * this.scale, (float)y * this.scale).floatValue();
            }
        }
        image.internalAssign(newimage);
    }
}

