/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.resize.ResizeFilterFunction;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processing.resize.filters.TriangleFilter;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class FixedResizeProcessor
implements SinglebandImageProcessor<Float, FImage> {
    private float newX;
    private float newY;
    private ResizeFilterFunction filterFunction;
    private float srcX;
    private float srcY;
    private ImageContributions ic;
    final float[] work;
    public static final ResizeFilterFunction DEFAULT_FILTER = TriangleFilter.INSTANCE;

    public FixedResizeProcessor(float srcX, float srcY, float newX, float newY, ResizeFilterFunction ff) {
        this.srcX = srcX;
        this.srcY = srcY;
        this.newX = newX;
        this.newY = newY;
        this.filterFunction = ff;
        this.prepareResample(true);
        this.work = new float[(int)newY];
    }

    public FixedResizeProcessor(float srcX, float srcY, float newX, float newY) {
        this(srcX, srcY, newX, newY, DEFAULT_FILTER);
    }

    public FixedResizeProcessor(FImage image, int newX, int newY) {
        this(image.width, image.height, newX, newY);
    }

    private void prepareResample(boolean aspect) {
        int nx = (int)this.newX;
        int ny = (int)this.newY;
        if (aspect) {
            if (ny > nx) {
                nx = (int)Math.round((double)(this.srcX * (float)ny) / (double)this.srcY);
            } else {
                ny = (int)Math.round((double)(this.srcY * (float)nx) / (double)this.srcX);
            }
        }
        this.newX = nx;
        this.newY = ny;
        this.ic = FixedResizeProcessor.prepareZoom((int)this.srcX, (int)this.srcY, (int)this.newX, (int)this.newY, this.filterFunction);
    }

    private static ImageContributions prepareZoom(int srcWidth, int srcHeight, int dstWidth, int dstHeight, ResizeFilterFunction filterf) {
        int i;
        double center;
        int k;
        int n;
        double weight;
        int j;
        double density;
        int right;
        int left;
        double center2;
        double xscale = (double)dstWidth / (double)srcWidth;
        double yscale = (double)dstHeight / (double)srcHeight;
        ResizeProcessor.PixelContributions[] contribY = new ResizeProcessor.PixelContributions[dstHeight];
        for (int i2 = 0; i2 < contribY.length; ++i2) {
            contribY[i2] = new ResizeProcessor.PixelContributions();
        }
        ResizeProcessor.PixelContributions[] contribX = new ResizeProcessor.PixelContributions[dstWidth];
        for (int i3 = 0; i3 < contribX.length; ++i3) {
            contribX[i3] = new ResizeProcessor.PixelContributions();
        }
        double fwidth = filterf.getSupport();
        if (yscale < 1.0) {
            double width = fwidth / yscale;
            double fscale = 1.0 / yscale;
            if (width <= 0.5) {
                width = 0.500001;
                fscale = 1.0;
            }
            for (int i4 = 0; i4 < dstHeight; ++i4) {
                contribY[i4].contributions = new ResizeProcessor.PixelContribution[(int)(width * 2.0 + 1.0)];
                contribY[i4].numberOfContributors = 0;
                center2 = (double)i4 / yscale;
                left = (int)Math.ceil(center2 - width);
                right = (int)Math.floor(center2 + width);
                density = 0.0;
                for (j = left; j <= right; ++j) {
                    weight = center2 - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    if (n >= srcHeight) {
                        n %= srcHeight;
                    } else if (n < 0) {
                        n = srcHeight - 1;
                    }
                    ++contribY[i4].numberOfContributors;
                    contribY[i4].contributions[k] = new ResizeProcessor.PixelContribution();
                    contribY[i4].contributions[k].pixel = n;
                    contribY[i4].contributions[k].weight = weight;
                    density += weight;
                }
                if (density == 0.0 || density == 1.0) continue;
                density = 1.0 / density;
                for (k = 0; k < contribY[i4].numberOfContributors; ++k) {
                    contribY[i4].contributions[k].weight *= density;
                }
            }
        } else {
            for (int i5 = 0; i5 < dstHeight; ++i5) {
                contribY[i5].contributions = new ResizeProcessor.PixelContribution[(int)(fwidth * 2.0 + 1.0)];
                contribY[i5].numberOfContributors = 0;
                center = (double)i5 / yscale;
                double left2 = Math.ceil(center - fwidth);
                double right2 = Math.floor(center + fwidth);
                int j2 = (int)left2;
                while ((double)j2 <= right2) {
                    double weight2 = center - (double)j2;
                    weight2 = filterf.filter(weight2);
                    int n2 = j2 < 0 ? -j2 : (j2 >= srcHeight ? srcHeight - j2 + srcHeight - 1 : j2);
                    if (n2 >= srcHeight) {
                        n2 %= srcHeight;
                    } else if (n2 < 0) {
                        n2 = srcHeight - 1;
                    }
                    ++contribY[i5].numberOfContributors;
                    contribY[i5].contributions[k] = new ResizeProcessor.PixelContribution();
                    contribY[i5].contributions[k].pixel = n2;
                    contribY[i5].contributions[k].weight = weight2;
                    ++j2;
                }
            }
        }
        if (xscale < 1.0) {
            for (i = 0; i < dstWidth; ++i) {
                double width = fwidth / xscale;
                double fscale = 1.0 / xscale;
                if (width <= 0.5) {
                    width = 0.500001;
                    fscale = 1.0;
                }
                contribX[i].numberOfContributors = 0;
                contribX[i].contributions = new ResizeProcessor.PixelContribution[(int)(width * 2.0 + 1.0)];
                center2 = (double)i / xscale;
                left = (int)Math.ceil(center2 - width);
                right = (int)Math.floor(center2 + width);
                density = 0.0;
                for (j = left; j <= right; ++j) {
                    weight = center2 - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    n = j < 0 ? -j : (j >= srcWidth ? srcWidth - j + srcWidth - 1 : j);
                    if (n >= srcWidth) {
                        n %= srcWidth;
                    } else if (n < 0) {
                        n = srcWidth - 1;
                    }
                    ++contribX[i].numberOfContributors;
                    contribX[i].contributions[k] = new ResizeProcessor.PixelContribution();
                    contribX[i].contributions[k].pixel = n;
                    contribX[i].contributions[k].weight = weight;
                    density += weight;
                }
                if (density == 0.0 || density == 1.0) continue;
                density = 1.0 / density;
                for (k = 0; k < contribX[i].numberOfContributors; ++k) {
                    contribX[i].contributions[k].weight *= density;
                }
            }
        } else {
            for (i = 0; i < dstWidth; ++i) {
                contribX[i].numberOfContributors = 0;
                contribX[i].contributions = new ResizeProcessor.PixelContribution[(int)(fwidth * 2.0 + 1.0)];
                center = (double)i / xscale;
                int left3 = (int)Math.ceil(center - fwidth);
                int right3 = (int)Math.floor(center + fwidth);
                for (int j3 = left3; j3 <= right3; ++j3) {
                    double weight3 = center - (double)j3;
                    weight3 = filterf.filter(weight3);
                    int n3 = j3 < 0 ? -j3 : (j3 >= srcWidth ? srcWidth - j3 + srcWidth - 1 : j3);
                    if (n3 >= srcWidth) {
                        n3 %= srcWidth;
                    } else if (n3 < 0) {
                        n3 = srcWidth - 1;
                    }
                    ++contribX[i].numberOfContributors;
                    contribX[i].contributions[k] = new ResizeProcessor.PixelContribution();
                    contribX[i].contributions[k].pixel = n3;
                    contribX[i].contributions[k].weight = weight3;
                }
            }
        }
        ImageContributions ic = new ImageContributions();
        ic.xContributions = contribX;
        ic.yContributions = contribY;
        return ic;
    }

    @Override
    public void processImage(FImage in) {
        if ((float)in.width != this.srcX || (float)in.height != this.srcY) {
            throw new RuntimeException("Incompatible image type used with FixedResizeProcessor, try the normal ResizeProcessor");
        }
        FImage dst = new FImage((int)this.newX, (int)this.newY);
        float maxValue = in.max().floatValue();
        for (int xx = 0; xx < dst.width; ++xx) {
            double pel2;
            int j;
            double pel;
            boolean bPelDelta;
            double weight;
            ResizeProcessor.PixelContributions contribX = this.ic.xContributions[xx];
            for (int k = 0; k < in.height; ++k) {
                weight = 0.0;
                bPelDelta = false;
                pel = in.pixels[k][contribX.contributions[0].pixel];
                for (j = 0; j < contribX.numberOfContributors; ++j) {
                    double d = pel2 = j == 0 ? pel : (double)in.pixels[k][contribX.contributions[j].pixel];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += pel2 * contribX.contributions[j].weight;
                }
                double d = weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : pel;
                if (weight < 0.0) {
                    weight = 0.0;
                } else if (weight > (double)maxValue) {
                    weight = maxValue;
                }
                this.work[k] = (float)weight;
            }
            for (int i = 0; i < dst.height; ++i) {
                weight = 0.0;
                bPelDelta = false;
                pel = this.work[this.ic.yContributions[i].contributions[0].pixel];
                for (j = 0; j < this.ic.yContributions[i].numberOfContributors; ++j) {
                    double d = pel2 = j == 0 ? pel : (double)this.work[this.ic.yContributions[i].contributions[j].pixel];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += pel2 * this.ic.yContributions[i].contributions[j].weight;
                }
                double d = weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : pel;
                if (weight < 0.0) {
                    weight = 0.0;
                } else if (weight > (double)maxValue) {
                    weight = maxValue;
                }
                dst.pixels[i][xx] = (float)weight;
            }
        }
        in.internalAssign(dst);
    }

    static class ImageContributions {
        ResizeProcessor.PixelContributions[] xContributions;
        ResizeProcessor.PixelContributions[] yContributions;

        ImageContributions() {
        }
    }
}

