/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.restoration.inpainting;

import java.util.PriorityQueue;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.SingleBandImage;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.processing.morphology.Dilate;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processing.restoration.inpainting.AbstractImageMaskInpainter;
import org.openimaj.image.processor.KernelProcessor;

@References(references={@Reference(type=ReferenceType.Article, author={"Telea, Alexandru"}, title="An Image Inpainting Technique Based on the Fast Marching Method.", year="2004", journal="J. Graphics, GPU, & Game Tools", pages={"23", "34"}, url="http://dblp.uni-trier.de/db/journals/jgtools/jgtools9.html#Telea04", number="1", volume="9", customData={"biburl", "http://www.bibsonomy.org/bibtex/2b0bf54e265d011a8e1fe256e6fcf556b/dblp", "ee", "http://dx.doi.org/10.1080/10867651.2004.10487596", "keywords", "dblp"}), @Reference(type=ReferenceType.Inproceedings, author={"J. A. Sethian"}, title="A Fast Marching Level Set Method for Monotonically Advancing Fronts", year="1995", booktitle="Proc. Nat. Acad. Sci", pages={"1591", "", "1595"})})
public abstract class AbstractFMMInpainter<IMAGE extends Image<?, IMAGE>>
extends AbstractImageMaskInpainter<IMAGE> {
    private static final int[][] DELTAS = new int[][]{{0, -1}, {-1, 0}, {0, 1}, {1, 0}};
    protected static byte KNOWN = 0;
    protected static byte BAND = 1;
    protected static byte UNKNOWN = (byte)2;
    protected byte[][] flag;
    protected FImage timeMap;
    protected PriorityQueue<FValuePixel> heap;

    @Override
    protected void initMask() {
        SingleBandImage outside = this.mask.process((KernelProcessor)new Dilate(StructuringElement.CROSS), true);
        this.flag = new byte[this.mask.height][this.mask.width];
        this.timeMap = new FImage(((FImage)outside).width, ((FImage)outside).height);
        this.heap = new PriorityQueue<FValuePixel>(10, FValuePixel.ValueComparator.INSTANCE);
        for (int y = 0; y < this.mask.height; ++y) {
            for (int x = 0; x < this.mask.width; ++x) {
                int band = (int)(((FImage)outside).pixels[y][x] - this.mask.pixels[y][x]);
                this.flag[y][x] = (byte)(2.0f * ((FImage)outside).pixels[y][x] - (float)band);
                if (this.flag[y][x] == UNKNOWN) {
                    this.timeMap.pixels[y][x] = Float.MAX_VALUE;
                }
                if (band == 0) continue;
                this.heap.add(new FValuePixel(x, y, this.timeMap.pixels[y][x]));
            }
        }
    }

    protected float solveEikonalStep(int x1, int y1, int x2, int y2) {
        float soln = Float.MAX_VALUE;
        float t1 = this.timeMap.pixels[y1][x1];
        float t2 = this.timeMap.pixels[y2][x2];
        if (this.flag[y1][x1] == KNOWN) {
            if (this.flag[y2][x2] == KNOWN) {
                float r = (float)Math.sqrt(2.0f - (t1 - t2) * (t1 - t2));
                float s = (t1 + t2 - r) * 0.5f;
                if (s >= t1 && s >= t2) {
                    soln = s;
                } else if ((s += r) >= t1 && s >= t2) {
                    soln = s;
                }
            } else {
                soln = 1.0f + t1;
            }
        } else if (this.flag[y2][x2] == KNOWN) {
            soln = 1.0f + t2;
        }
        return soln;
    }

    @Override
    public void performInpainting(IMAGE image) {
        int width = ((Image)image).getWidth();
        int height = ((Image)image).getHeight();
        while (!this.heap.isEmpty()) {
            FValuePixel pix = this.heap.poll();
            int x = pix.x;
            int y = pix.y;
            this.flag[y][x] = KNOWN;
            if (x <= 1 || y <= 1 || x >= width - 2 || y >= height - 2) continue;
            for (int[] p : DELTAS) {
                int yp = p[1] + y;
                int xp = p[0] + x;
                if (this.flag[yp][xp] == KNOWN) continue;
                this.timeMap.pixels[yp][xp] = Math.min(Math.min(Math.min(this.solveEikonalStep(xp - 1, yp, xp, yp - 1), this.solveEikonalStep(xp + 1, yp, xp, yp - 1)), this.solveEikonalStep(xp - 1, yp, xp, yp + 1)), this.solveEikonalStep(xp + 1, yp, xp, yp + 1));
                if (this.flag[yp][xp] != UNKNOWN) continue;
                this.flag[yp][xp] = BAND;
                this.heap.offer(new FValuePixel(xp, yp, this.timeMap.pixels[yp][xp]));
                this.inpaint(xp, yp, image);
            }
        }
    }

    protected abstract void inpaint(int var1, int var2, IMAGE var3);
}

