/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.restoration.inpainting;

import java.util.Set;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processing.restoration.inpainting.AbstractFMMInpainter;

@Reference(type=ReferenceType.Article, author={"Telea, Alexandru"}, title="An Image Inpainting Technique Based on the Fast Marching Method.", year="2004", journal="J. Graphics, GPU, & Game Tools", pages={"23", "34"}, url="http://dblp.uni-trier.de/db/journals/jgtools/jgtools9.html#Telea04", number="1", volume="9", customData={"biburl", "http://www.bibsonomy.org/bibtex/2b0bf54e265d011a8e1fe256e6fcf556b/dblp", "doi", "http://dx.doi.org/10.1080/10867651.2004.10487596", "keywords", "dblp"})
public class TeleaInpainting<IMAGE extends Image<?, IMAGE>>
extends AbstractFMMInpainter<IMAGE> {
    protected Set<Pixel> region;

    public TeleaInpainting(int radius) {
        this.region = StructuringElement.disk((int)radius).positive;
    }

    @Override
    protected void inpaint(int x, int y, IMAGE image) {
        if (image instanceof FImage) {
            this.inpaint(x, y, (FImage)image);
        } else if (image instanceof MBFImage) {
            this.inpaint(x, y, (MBFImage)image);
        } else {
            throw new UnsupportedOperationException("Image type not supported!");
        }
    }

    @Override
    protected void inpaint(int x, int y, FImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        float gradx_u = this.gradX(this.timeMap.pixels, x, y);
        float grady_u = this.gradY(this.timeMap.pixels, x, y);
        float accum = 0.0f;
        float norm = 0.0f;
        for (Pixel p : this.region) {
            int xx = p.x + x;
            int yy = p.y + y;
            if (xx <= 1 || xx >= width - 1 || yy <= 1 || yy >= height - 1 || this.flag[yy][xx] != KNOWN) continue;
            int rx = x - xx;
            int ry = y - yy;
            float geometricDistance = (float)(1.0 / ((double)(rx * rx + ry * ry) * Math.sqrt(rx * rx + ry * ry)));
            float levelsetDistance = (float)(1.0 / (double)(1.0f + Math.abs(this.timeMap.pixels[yy][xx] - this.timeMap.pixels[y][x])));
            float direction = Math.abs((float)rx * gradx_u + (float)ry * grady_u);
            if (direction < 1.0E-6f) {
                direction = 1.0E-6f;
            }
            float weight = geometricDistance * levelsetDistance * direction;
            accum += weight * input.pixels[yy][xx];
            norm += weight;
        }
        input.pixels[y][x] = accum / norm;
    }

    @Override
    protected void inpaint(int x, int y, MBFImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        float gradx_u = this.gradX(this.timeMap.pixels, x, y);
        float grady_u = this.gradY(this.timeMap.pixels, x, y);
        int nbands = input.numBands();
        float[] accum = new float[nbands];
        float norm = 0.0f;
        for (Pixel p : this.region) {
            int xx = p.x + x;
            int yy = p.y + y;
            if (xx <= 1 || xx >= width - 1 || yy <= 1 || yy >= height - 1 || this.flag[yy][xx] != KNOWN) continue;
            int rx = x - xx;
            int ry = y - yy;
            float geometricDistance = (float)(1.0 / ((double)(rx * rx + ry * ry) * Math.sqrt(rx * rx + ry * ry)));
            float levelsetDistance = (float)(1.0 / (double)(1.0f + Math.abs(this.timeMap.pixels[yy][xx] - this.timeMap.pixels[y][x])));
            float direction = Math.abs((float)rx * gradx_u + (float)ry * grady_u);
            if (direction < 1.0E-6f) {
                direction = 1.0E-6f;
            }
            float weight = geometricDistance * levelsetDistance * direction;
            for (int i = 0; i < nbands; ++i) {
                int n = i;
                accum[n] = accum[n] + weight * ((FImage)input.getBand((int)i)).pixels[yy][xx];
            }
            norm += weight;
        }
        for (int i = 0; i < nbands; ++i) {
            ((FImage)input.getBand((int)i)).pixels[y][x] = accum[i] / norm;
        }
    }

    private float gradX(float[][] img, int x, int y) {
        float grad = this.flag[y][x + 1] != UNKNOWN ? (this.flag[y][x - 1] != UNKNOWN ? (img[y][x + 1] - img[y][x - 1]) * 0.5f : img[y][x + 1] - img[y][x]) : (this.flag[y][x - 1] != UNKNOWN ? img[y][x] - img[y][x - 1] : 0.0f);
        return grad;
    }

    private float gradY(float[][] img, int x, int y) {
        float grad = this.flag[y + 1][x] != UNKNOWN ? (this.flag[y - 1][x] != UNKNOWN ? (img[y + 1][x] - img[y - 1][x]) * 0.5f : img[y + 1][x] - img[y][x]) : (this.flag[y - 1][x] != UNKNOWN ? img[y][x] - img[y - 1][x] : 0.0f);
        return grad;
    }
}

