/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.threshold;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.algorithm.FilterSupport;
import org.openimaj.image.processing.algorithm.LocalContrastFilter;
import org.openimaj.image.processing.convolution.AverageBoxFilter;
import org.openimaj.image.processing.threshold.AbstractLocalThreshold;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class AdaptiveLocalThresholdBernsen
extends AbstractLocalThreshold {
    private float threshold;

    public AdaptiveLocalThresholdBernsen(float threshold, int size) {
        super(size);
        this.threshold = threshold;
    }

    public AdaptiveLocalThresholdBernsen(float threshold, int size_x, int size_y) {
        super(size_x, size_y);
        this.threshold = threshold;
    }

    @Override
    public void processImage(FImage image) {
        FImage contrast = (FImage)image.process((SinglebandImageProcessor)new LocalContrastFilter(FilterSupport.createBlockSupport(this.sizeX, this.sizeY)));
        FImage avg = (FImage)image.process((SinglebandImageProcessor)new AverageBoxFilter(this.sizeX, this.sizeY));
        float[][] cpix = contrast.pixels;
        float[][] mpix = avg.pixels;
        float[][] ipix = image.pixels;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                ipix[y][x] = cpix[y][x] < this.threshold ? (mpix[y][x] >= 128.0f ? 1.0f : 0.0f) : (ipix[y][x] >= mpix[y][x] ? 1.0f : 0.0f);
            }
        }
    }
}

