/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.threshold;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.pair.FloatFloatPair;

@Reference(type=ReferenceType.Article, author={"Nobuyuki Otsu"}, title="A Threshold Selection Method from Gray-Level Histograms", year="1979", journal="Systems, Man and Cybernetics, IEEE Transactions on", pages={"62", "66"}, number="1", volume="9", customData={"keywords", "Displays;Gaussian distribution;Histograms;Least squares approximation;Marine vehicles;Q measurement;Radar tracking;Sea measurements;Surveillance;Target tracking", "doi", "10.1109/TSMC.1979.4310076", "ISSN", "0018-9472"})
public class OtsuThreshold
implements ImageProcessor<FImage> {
    private static final int DEFAULT_NUM_BINS = 256;
    int numBins = 256;

    public OtsuThreshold() {
    }

    public OtsuThreshold(int numBins) {
        this.numBins = numBins;
    }

    protected static int[] makeHistogram(FImage fimg, int numBins) {
        int[] histData = new int[numBins];
        for (int r = 0; r < fimg.height; ++r) {
            for (int c = 0; c < fimg.width; ++c) {
                int h;
                int n = h = (int)(fimg.pixels[r][c] * (float)(numBins - 1));
                histData[n] = histData[n] + 1;
            }
        }
        return histData;
    }

    protected static int[] makeHistogram(float[] data, int numBins, float min, float max) {
        int[] histData = new int[numBins];
        for (int c = 0; c < data.length; ++c) {
            int h;
            float d = (data[c] - min) / (max - min);
            int n = h = (int)(d * (float)(numBins - 1));
            histData[n] = histData[n] + 1;
        }
        return histData;
    }

    public static float calculateThreshold(FImage img, int numBins) {
        int[] histData = OtsuThreshold.makeHistogram(img, numBins);
        int total = img.getWidth() * img.getHeight();
        return OtsuThreshold.computeThresholdFromHistogram(histData, total);
    }

    public static float calculateThreshold(float[] data, int numBins) {
        float min = ArrayUtils.minValue(data);
        float max = ArrayUtils.maxValue(data);
        int[] histData = OtsuThreshold.makeHistogram(data, numBins, min, max);
        return OtsuThreshold.computeThresholdFromHistogram(histData, data.length) + min;
    }

    public static FloatFloatPair calculateThresholdAndVariance(float[] data, int numBins) {
        float min = ArrayUtils.minValue(data);
        float max = ArrayUtils.maxValue(data);
        int[] histData = OtsuThreshold.makeHistogram(data, numBins, min, max);
        FloatFloatPair result = OtsuThreshold.computeThresholdAndVarianceFromHistogram(histData, data.length);
        result.first += min;
        return result;
    }

    public static float computeThresholdFromHistogram(int[] histData, int total) {
        return OtsuThreshold.computeThresholdAndVarianceFromHistogram((int[])histData, (int)total).first;
    }

    public static FloatFloatPair computeThresholdAndVarianceFromHistogram(int[] histData, int total) {
        int numBins = histData.length;
        float sum = 0.0f;
        for (int t = 0; t < numBins; ++t) {
            sum += (float)(t * histData[t]);
        }
        float sumB = 0.0f;
        int wB = 0;
        int wF = 0;
        float varMax = 0.0f;
        float threshold = 0.0f;
        for (int t = 0; t < numBins; ++t) {
            float mF;
            float varBetween;
            if ((wB += histData[t]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(t * histData[t])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = t;
        }
        return new FloatFloatPair(threshold / (float)(numBins - 1), varMax / (float)total / (float)total);
    }

    @Override
    public void processImage(FImage image) {
        float threshold = OtsuThreshold.calculateThreshold(image, this.numBins);
        image.threshold(Float.valueOf(threshold));
    }
}

