/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.ImageInterpolation;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class RemapProcessor
implements SinglebandImageProcessor<Float, FImage> {
    ImageInterpolation interpolation;
    FImage xords;
    FImage yords;

    public RemapProcessor(FImage xords, FImage yords) {
        this(xords, yords, ImageInterpolation.InterpolationType.BILINEAR);
    }

    public RemapProcessor(FImage xords, FImage yords, ImageInterpolation.Interpolator interpolator) {
        this.interpolation = new ImageInterpolation(interpolator);
        this.xords = xords;
        this.yords = yords;
    }

    @Override
    public void processImage(FImage image) {
        FImage out = RemapProcessor.remap(image, this.xords, this.yords, this.interpolation);
        image.internalAssign(out);
    }

    public static FImage remap(FImage in, FImage xords, FImage yords, ImageInterpolation.Interpolator interpolator) {
        return RemapProcessor.remap(in, xords, yords, new ImageInterpolation(interpolator));
    }

    public static FImage remap(FImage in, FImage xords, FImage yords, ImageInterpolation interpolation) {
        return RemapProcessor.remap(in, new FImage(xords.width, xords.height), xords, yords, interpolation);
    }

    public static FImage remap(FImage in, FImage out, FImage xords, FImage yords, ImageInterpolation interpolation) {
        int width = Math.min(xords.width, out.width);
        int height = Math.min(xords.height, out.height);
        interpolation.analyseImage(in);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                out.pixels[y][x] = interpolation.getPixelInterpolated(xords.pixels[y][x], yords.pixels[y][x]);
            }
        }
        return out;
    }

    public static FImage remap(FImage in, FImage xords, FImage yords) {
        return RemapProcessor.remap(in, xords, yords, new ImageInterpolation(ImageInterpolation.InterpolationType.BILINEAR));
    }

    public static FImage remap(FImage in, FImage out, FImage xords, FImage yords) {
        return RemapProcessor.remap(in, out, xords, yords, new ImageInterpolation(ImageInterpolation.InterpolationType.BILINEAR));
    }
}

