/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processor.connectedcomponent.render;

import org.openimaj.image.Image;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.render.AbstractRenderer;

public class BoundingBoxRenderer<T>
extends AbstractRenderer<T> {
    protected boolean fill;

    public BoundingBoxRenderer(Image<T, ?> image, T colour, boolean fill) {
        super(image, colour);
        this.fill = fill;
    }

    public BoundingBoxRenderer(int width, int height, T colour, boolean fill) {
        super(width, height, colour);
        this.fill = fill;
    }

    @Override
    public void process(ConnectedComponent cc) {
        if (this.fill) {
            this.image.drawShapeFilled(cc.calculateRegularBoundingBox(), this.colour);
        } else {
            this.image.drawShape(cc.calculateRegularBoundingBox(), this.colour);
        }
    }
}

