/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.path.resample;

import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.path.Polyline;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.util.Interpolation;
import org.openimaj.util.function.Function;
import org.openimaj.util.function.Operation;

public class LinearResampler
implements Function<Polyline, Polyline>,
Operation<Polyline> {
    int targetVertices;

    public LinearResampler(int targetVertices) {
        this.targetVertices = targetVertices;
    }

    @Override
    public Polyline apply(Polyline in) {
        double lastLength;
        double length = in.calculateLength();
        double step = length / (double)(this.targetVertices - 1);
        Polyline out = new Polyline(new Point2d[0]);
        out.points.add(in.begin().copy());
        Point2d begin = (Point2d)in.points.get(0);
        Point2d end = (Point2d)in.points.get(1);
        double distance = lastLength = Line2d.distance(begin, end);
        double pos = step;
        int i = 1;
        int c = 1;
        while (i < this.targetVertices - 1) {
            while (pos > distance) {
                begin = end;
                end = (Point2d)in.points.get(++c);
                lastLength = Line2d.distance(begin, end);
                distance += lastLength;
            }
            double offset = lastLength - (distance - pos);
            Point2d np = begin.copy();
            for (int j = 0; j < 2; ++j) {
                double n = Interpolation.lerp(offset, 0.0, begin.getOrdinate(j).doubleValue(), lastLength, end.getOrdinate(j).doubleValue());
                np.setOrdinate(j, n);
            }
            out.points.add(np);
            ++i;
            pos += step;
        }
        out.points.add(in.end().copy());
        return out;
    }

    @Override
    public void perform(Polyline object) {
        Polyline n = this.apply(object);
        object.points = n.points;
    }
}

