/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.point.PointList;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.EllipseUtilities;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.shape.util.PolygonUtils;
import org.openimaj.math.geometry.shape.util.RotatingCalipers;

public class Polygon
extends PointList
implements Shape {
    private List<Polygon> innerPolygons = new ArrayList<Polygon>();
    private boolean isHole = false;

    public Polygon() {
        this(false);
    }

    public Polygon(boolean representsHole) {
        super(new Point2d[0]);
        this.isHole = representsHole;
    }

    public Polygon(Point2d ... vertices) {
        super(vertices);
    }

    public Polygon(Collection<? extends Point2d> vertices) {
        this(vertices, false);
    }

    public Polygon(Collection<? extends Point2d> vertices, boolean copy) {
        super(vertices, copy);
    }

    public List<Point2d> getVertices() {
        return this.points;
    }

    public int nVertices() {
        if (this.isClosed()) {
            return this.points.size() - 1;
        }
        return this.points.size();
    }

    public boolean isClosed() {
        return this.points.size() > 0 && ((Point2d)this.points.get(0)).getX() == ((Point2d)this.points.get(this.points.size() - 1)).getX() && ((Point2d)this.points.get(0)).getY() == ((Point2d)this.points.get(this.points.size() - 1)).getY();
    }

    public void close() {
        if (!this.isClosed() && this.points.size() > 0) {
            this.points.add(this.points.get(0));
        }
    }

    public void open() {
        if (this.isClosed() && this.points.size() > 1) {
            this.points.remove(this.points.size() - 1);
        }
    }

    @Override
    public boolean isInside(Point2d point) {
        boolean isClosed = this.isClosed();
        if (!isClosed) {
            this.close();
        }
        boolean isOdd = false;
        float px = point.getX();
        float py = point.getY();
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            List<Point2d> v = this.getInnerPoly(pp).getVertices();
            int j = v.size() - 1;
            float vjx = v.get(j).getX();
            float vjy = v.get(j).getY();
            int i = 0;
            while (i < v.size()) {
                float vix = v.get(i).getX();
                float viy = v.get(i).getY();
                if ((viy < py && vjy >= py || vjy < py && viy >= py) && vix + (py - viy) / (vjy - viy) * (vjx - vix) < px) {
                    isOdd = !isOdd;
                }
                j = i++;
                vjx = vix;
                vjy = viy;
            }
        }
        if (!isClosed) {
            this.open();
        }
        return isOdd;
    }

    @Override
    public Polygon clone() {
        Polygon clone = new Polygon();
        clone.setIsHole(this.isHole);
        for (Point2d p : this.points) {
            clone.points.add(p.copy());
        }
        for (Polygon innerPoly : this.innerPolygons) {
            clone.addInnerPolygon(innerPoly.clone());
        }
        return clone;
    }

    public Polygon difference(Polygon p) {
        ArrayList<Point2dImpl> v = new ArrayList<Point2dImpl>();
        for (int i = 0; i < this.nVertices(); ++i) {
            v.add(new Point2dImpl(((Point2d)this.points.get(i)).getX() - ((Point2d)p.points.get(i)).getX(), ((Point2d)this.points.get(i)).getY() - ((Point2d)p.points.get(i)).getY()));
        }
        Polygon p2 = new Polygon(v);
        for (int i = 0; i < this.innerPolygons.size(); ++i) {
            p2.addInnerPolygon(this.innerPolygons.get(i).difference(p2.getInnerPoly(i + 1)));
        }
        return p2;
    }

    @Override
    public double calculateArea() {
        return Math.abs(this.calculateSignedArea());
    }

    public double calculateSignedArea() {
        boolean closed = this.isClosed();
        double area = 0.0;
        if (!closed) {
            this.close();
        }
        for (int k = 0; k < this.points.size() - 1; ++k) {
            float ik = ((Point2d)this.points.get(k)).getX();
            float jk = ((Point2d)this.points.get(k)).getY();
            float ik1 = ((Point2d)this.points.get(k + 1)).getX();
            float jk1 = ((Point2d)this.points.get(k + 1)).getY();
            area += (double)(ik * jk1 - ik1 * jk);
        }
        if (!closed) {
            this.open();
        }
        return 0.5 * area;
    }

    @Override
    public double intersectionArea(Shape that) {
        return this.intersectionArea(that, 1);
    }

    @Override
    public double intersectionArea(Shape that, int nStepsPerDimension) {
        Rectangle overlapping = this.calculateRegularBoundingBox().overlapping(that.calculateRegularBoundingBox());
        if (overlapping == null) {
            return 0.0;
        }
        double intersection = 0.0;
        double step = (double)Math.max(overlapping.width, overlapping.height) / (double)nStepsPerDimension;
        double nReads = 0.0;
        float x = overlapping.x;
        while (x < overlapping.x + overlapping.width) {
            float y = overlapping.y;
            while (y < overlapping.y + overlapping.height) {
                boolean insideThis = this.isInside(new Point2dImpl(x, y));
                boolean insideThat = that.isInside(new Point2dImpl(x, y));
                nReads += 1.0;
                if (insideThis && insideThat) {
                    intersection += 1.0;
                }
                y = (float)((double)y + step);
            }
            x = (float)((double)x + step);
        }
        return intersection / nReads * (double)(overlapping.width * overlapping.height);
    }

    @Override
    public Polygon asPolygon() {
        return this;
    }

    public void addVertex(float x, float y) {
        this.points.add(new Point2dImpl(x, y));
    }

    public void addVertex(Point2d pt) {
        this.points.add(pt);
    }

    public Polygon roundVertices() {
        for (Point2d p : this) {
            p.setX(Math.round(p.getX()));
            p.setY(Math.round(p.getY()));
        }
        for (Polygon pp : this.innerPolygons) {
            pp.roundVertices();
        }
        return this;
    }

    public boolean isEmpty() {
        return this.points.isEmpty() && this.innerPolygons.isEmpty();
    }

    public int getNumInnerPoly() {
        return this.innerPolygons.size() + 1;
    }

    public Polygon getInnerPoly(int index) {
        if (index == 0) {
            return this;
        }
        return this.innerPolygons.get(index - 1);
    }

    public void addInnerPolygon(Polygon p, boolean inferOuter) {
        if (!inferOuter) {
            this.innerPolygons.add(p);
        } else if (this.points.size() == 0) {
            this.points.addAll(p.points);
            this.isHole = p.isHole;
        } else {
            this.addInnerPolygon(p, false);
        }
    }

    public void addInnerPolygon(Polygon p) {
        this.addInnerPolygon(p, true);
    }

    public List<Polygon> getInnerPolys() {
        return this.innerPolygons;
    }

    public void setIsHole(boolean isHole) {
        this.isHole = isHole;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public boolean equals(Object obj) {
        return obj instanceof Polygon && this.equals((Polygon)obj);
    }

    public boolean equals(Polygon p) {
        if (this.isHole() != p.isHole()) {
            return false;
        }
        if (this.points.size() != p.points.size()) {
            return false;
        }
        if (this.isEmpty() && p.isEmpty()) {
            return true;
        }
        int i = this.points.indexOf(p.points.get(0));
        if (i == -1) {
            return false;
        }
        int s = this.points.size();
        for (int n = 0; n < s; ++n) {
            if (((Point2d)p.points.get(n)).equals(this.points.get((n + i) % s))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.points.hashCode() * (this.isHole() ? -1 : 1);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isHole()) {
            sb.append("H");
        }
        int len = 10;
        if (this.points.size() < 10) {
            sb.append(this.points.toString());
        } else {
            sb.append(this.points.subList(0, 5).toString() + "..." + this.points.subList(this.points.size() - 5, this.points.size()).toString());
        }
        if (this.innerPolygons.size() > 0) {
            sb.append("\n    - " + this.innerPolygons.size() + " inner polygons:");
            for (Polygon ip : this.innerPolygons) {
                sb.append("\n       + " + ip.toString());
            }
        }
        return sb.toString();
    }

    public Polygon intersect(Polygon p2) {
        Polygon clone = new PolygonUtils().intersection(new Polygon(this.points), p2);
        clone.setIsHole(this.isHole);
        for (Polygon innerPoly : this.innerPolygons) {
            clone.addInnerPolygon(innerPoly.intersect(p2));
        }
        return clone;
    }

    public Polygon union(Polygon p2) {
        return new PolygonUtils().union(this, p2);
    }

    public Polygon xor(Polygon p2) {
        return new PolygonUtils().xor(this, p2);
    }

    public Polygon reduceVertices(double eps) {
        if (eps == 0.0 || this.nVertices() <= 3) {
            return this.clone();
        }
        int prevStartIndex = 0;
        int startIndex = 0;
        for (int init = 0; init < 3; ++init) {
            double dmax = 0.0;
            prevStartIndex = startIndex;
            Point2d first = (Point2d)this.points.get(startIndex);
            for (int i = 0; i < this.points.size(); ++i) {
                double d = Line2d.distance(first, (Point2d)this.points.get(i));
                if (!(d > dmax)) continue;
                startIndex = i;
                dmax = d;
            }
        }
        if (prevStartIndex > startIndex) {
            int tmp = prevStartIndex;
            prevStartIndex = startIndex;
            startIndex = tmp;
        }
        ArrayList<Point2d> l1 = new ArrayList<Point2d>();
        l1.addAll(this.points.subList(prevStartIndex, startIndex + 1));
        ArrayList<Point2d> l2 = new ArrayList<Point2d>();
        l2.addAll(this.points.subList(startIndex, this.points.size()));
        l2.addAll(this.points.subList(0, prevStartIndex + 1));
        Polygon newPoly = new Polygon();
        List<Point2d> line1 = Polygon.ramerDouglasPeucker(l1, eps);
        List<Point2d> line2 = Polygon.ramerDouglasPeucker(l2, eps);
        newPoly.points.addAll(line1.subList(0, line1.size() - 1));
        newPoly.points.addAll(line2.subList(0, line2.size() - 1));
        if (!newPoly.isClockwise()) {
            Collections.reverse(newPoly.points);
        }
        for (Polygon ppp : this.innerPolygons) {
            newPoly.addInnerPolygon(ppp.reduceVertices(eps));
        }
        return newPoly;
    }

    private static List<Point2d> ramerDouglasPeucker(List<Point2d> p, double eps) {
        double dmax = 0.0;
        int index = 0;
        int end = p.size() - 1;
        Line2d l = new Line2d(p.get(0), p.get(end));
        for (int i = 1; i < end - 1; ++i) {
            double d;
            Point2d p1 = p.get(i);
            Line2d norm = l.getNormal(p1);
            Point2d p2 = l.getIntersection((Line2d)norm).intersectionPoint;
            if (p2 == null || !((d = Line2d.distance(p1, p2)) > dmax)) continue;
            index = i;
            dmax = d;
        }
        ArrayList<Point2d> newPoly = new ArrayList<Point2d>();
        if (dmax > eps) {
            List<Point2d> line1 = Polygon.ramerDouglasPeucker(p.subList(0, index + 1), eps);
            List<Point2d> line2 = Polygon.ramerDouglasPeucker(p.subList(index, end + 1), eps);
            newPoly.addAll(line1.subList(0, line1.size() - 1));
            newPoly.addAll(line2);
        } else {
            newPoly.add(p.get(0));
            newPoly.add(p.get(end));
        }
        return newPoly;
    }

    @Override
    public Polygon transform(Matrix transform) {
        ArrayList<Point2dImpl> newVertices = new ArrayList<Point2dImpl>();
        for (Point2d p : this.points) {
            Matrix p1 = new Matrix(3, 1);
            p1.set(0, 0, p.getX());
            p1.set(1, 0, p.getY());
            p1.set(2, 0, 1.0);
            Matrix p2_est = transform.times(p1);
            Point2dImpl out = new Point2dImpl((float)(p2_est.get(0, 0) / p2_est.get(2, 0)), (float)(p2_est.get(1, 0) / p2_est.get(2, 0)));
            newVertices.add(out);
        }
        Polygon p = new Polygon(newVertices);
        for (Polygon pp : this.innerPolygons) {
            p.addInnerPolygon(pp.transform(transform));
        }
        return p;
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        float xmin = Float.MAX_VALUE;
        float xmax = -3.4028235E38f;
        float ymin = Float.MAX_VALUE;
        float ymax = -3.4028235E38f;
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                float px = p.getX();
                float py = p.getY();
                if (px < xmin) {
                    xmin = px;
                }
                if (px > xmax) {
                    xmax = px;
                }
                if (py < ymin) {
                    ymin = py;
                }
                if (!(py > ymax)) continue;
                ymax = py;
            }
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public void translate(float x, float y) {
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                p.setX(p.getX() + x);
                p.setY(p.getY() + y);
            }
        }
    }

    @Override
    public void scale(float sc) {
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                p.setX(p.getX() * sc);
                p.setY(p.getY() * sc);
            }
        }
    }

    @Override
    public Polygon scaleX(float sc) {
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                p.setX(p.getX() * sc);
            }
        }
        return this;
    }

    @Override
    public Polygon scaleY(float sc) {
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                p.setY(p.getY() * sc);
            }
        }
        return this;
    }

    @Override
    public Polygon scaleXY(float scx, float scy) {
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                p.setX(p.getX() * scx);
                p.setY(p.getY() * scy);
            }
        }
        return this;
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        for (int pp = 0; pp < this.getNumInnerPoly(); ++pp) {
            Polygon ppp = this.getInnerPoly(pp);
            for (int i = 0; i < ppp.nVertices(); ++i) {
                Point2d p = (Point2d)ppp.points.get(i);
                p.setX(p.getX() * sc);
                p.setY(p.getY() * sc);
            }
        }
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public Point2d calculateCentroid() {
        double[] pt = this.calculateFirstMoment();
        return new Point2dImpl((float)pt[0], (float)pt[1]);
    }

    @Reference(author={"Carsten Steger"}, title="On the Calculation of Moments of Polygons", type=ReferenceType.Techreport, month="August", year="1996", url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.29.8765&rep=rep1&type=pdf")
    public double[] calculateFirstMoment() {
        boolean closed = this.isClosed();
        if (!closed) {
            this.close();
        }
        double area = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        for (int k = 0; k < this.points.size() - 1; ++k) {
            float xk = ((Point2d)this.points.get(k)).getX();
            float yk = ((Point2d)this.points.get(k)).getY();
            float xk1 = ((Point2d)this.points.get(k + 1)).getX();
            float yk1 = ((Point2d)this.points.get(k + 1)).getY();
            float shared = xk * yk1 - xk1 * yk;
            area += (double)shared;
            ax += (double)((xk + xk1) * shared);
            ay += (double)((yk + yk1) * shared);
        }
        if (!closed) {
            this.open();
        }
        return new double[]{ax / (6.0 * (area *= 0.5)), ay / (6.0 * area)};
    }

    @Reference(author={"Carsten Steger"}, title="On the Calculation of Moments of Polygons", type=ReferenceType.Techreport, month="August", year="1996", url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.29.8765&rep=rep1&type=pdf")
    public double[] calculateSecondMoment() {
        boolean closed = this.isClosed();
        double area = this.calculateSignedArea();
        if (!closed) {
            this.close();
        }
        double axx = 0.0;
        double ayy = 0.0;
        double axy = 0.0;
        for (int k = 0; k < this.points.size() - 1; ++k) {
            float xk = ((Point2d)this.points.get(k)).getX();
            float yk = ((Point2d)this.points.get(k)).getY();
            float xk1 = ((Point2d)this.points.get(k + 1)).getX();
            float yk1 = ((Point2d)this.points.get(k + 1)).getY();
            float shared = xk * yk1 - xk1 * yk;
            axx += (double)((xk * xk + xk * xk1 + xk1 * xk1) * shared);
            ayy += (double)((yk * yk + yk * yk1 + yk1 * yk1) * shared);
            axy += (double)((2.0f * xk * yk + xk * yk1 + xk1 * yk + 2.0f * xk1 * yk1) * shared);
        }
        if (!closed) {
            this.open();
        }
        return new double[]{axx / (12.0 * area), axy / (24.0 * area), ayy / (12.0 * area)};
    }

    @Reference(author={"Carsten Steger"}, title="On the Calculation of Moments of Polygons", type=ReferenceType.Techreport, month="August", year="1996", url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.29.8765&rep=rep1&type=pdf")
    public double[] calculateSecondMomentCentralised() {
        double[] firstMoment = this.calculateFirstMoment();
        double[] secondMoment = this.calculateSecondMoment();
        return new double[]{secondMoment[0] - firstMoment[0] * firstMoment[0], secondMoment[1] - firstMoment[0] * firstMoment[1], secondMoment[2] - firstMoment[1] * firstMoment[1]};
    }

    public double calculateDirection() {
        double[] secondMoment = this.calculateSecondMomentCentralised();
        double u20 = secondMoment[0];
        double u02 = secondMoment[1];
        double u11 = secondMoment[2];
        double theta = 0.5 * Math.atan2(2.0 * u11, u20 - u02);
        return theta;
    }

    public Ellipse toEllipse() {
        double[] secondMoment = this.calculateSecondMomentCentralised();
        double u20 = secondMoment[0];
        double u11 = secondMoment[1];
        double u02 = secondMoment[2];
        Point2d center = this.calculateCentroid();
        Matrix sm = new Matrix(new double[][]{{u20, u11}, {u11, u02}});
        return EllipseUtilities.ellipseFromCovariance(center.getX(), center.getY(), sm, (float)Math.sqrt(3.0));
    }

    @Override
    public boolean isConvex() {
        int size;
        boolean isOriginallyClosed = this.isClosed();
        if (isOriginallyClosed) {
            this.open();
        }
        if ((size = this.size()) < 3) {
            return false;
        }
        float res = 0.0f;
        for (int i = 0; i < size; ++i) {
            Point2d p = (Point2d)this.points.get(i);
            Point2d tmp = (Point2d)this.points.get((i + 1) % size);
            Point2dImpl v = new Point2dImpl();
            v.x = tmp.getX() - p.getX();
            v.y = tmp.getY() - p.getY();
            Point2d u = (Point2d)this.points.get((i + 2) % size);
            if (i == 0) {
                res = u.getX() * v.y - u.getY() * v.x + v.x * p.getY() - v.y * p.getX();
                continue;
            }
            float newres = u.getX() * v.y - u.getY() * v.x + v.x * p.getY() - v.y * p.getX();
            if (!(newres > 0.0f && res < 0.0f) && (!(newres < 0.0f) || !(res > 0.0f))) continue;
            return false;
        }
        if (isOriginallyClosed) {
            this.close();
        }
        return true;
    }

    public boolean hasNoInnerPolygons() {
        return this.innerPolygons == null || this.innerPolygons.size() == 0;
    }

    @Override
    public double calculatePerimeter() {
        Point2d p1 = (Point2d)this.points.get(0);
        float p1x = p1.getX();
        float p1y = p1.getY();
        Point2d p2 = (Point2d)this.points.get(this.points.size() - 1);
        float p2x = p2.getX();
        float p2y = p2.getY();
        double peri = Line2d.distance(p1x, p1y, p2x, p2y);
        for (int i = 1; i < this.points.size(); ++i) {
            p2 = (Point2d)this.points.get(i);
            p2x = p2.getX();
            p2y = p2.getY();
            peri += Line2d.distance(p1x, p1y, p2x, p2y);
            p1x = p2x;
            p1y = p2y;
        }
        return peri;
    }

    public boolean isClockwise() {
        double signedArea = 0.0;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            float x1 = ((Point2d)this.points.get(i)).getX();
            float y1 = ((Point2d)this.points.get(i)).getY();
            float x2 = ((Point2d)this.points.get(i + 1)).getX();
            float y2 = ((Point2d)this.points.get(i + 1)).getY();
            signedArea += (double)(x1 * y2 - x2 * y1);
        }
        float x1 = ((Point2d)this.points.get(this.points.size() - 1)).getX();
        float y1 = ((Point2d)this.points.get(this.points.size() - 1)).getY();
        float x2 = ((Point2d)this.points.get(0)).getX();
        float y2 = ((Point2d)this.points.get(0)).getY();
        return (signedArea += (double)(x1 * y2 - x2 * y1)) >= 0.0;
    }

    public Polygon calculateConvexHullMelkman() {
        if (this.points.size() <= 3) {
            return new Polygon(this.points);
        }
        int n = this.points.size();
        int i = 1;
        while (i + 1 < n && this.isLeft((Point2d)this.points.get(0), (Point2d)this.points.get(i), (Point2d)this.points.get(i + 1)) == 0.0f) {
            ++i;
        }
        if (n - i <= 3) {
            return new Polygon(this.points);
        }
        Point2d[] D = new Point2d[2 * n + 1];
        int bot = n - 2;
        int top = bot + 3;
        D[bot] = D[top] = (Point2d)this.points.get(i + 1);
        if (this.isLeft((Point2d)this.points.get(0), (Point2d)this.points.get(i), (Point2d)this.points.get(i + 1)) > 0.0f) {
            D[bot + 1] = (Point2d)this.points.get(0);
            D[bot + 2] = (Point2d)this.points.get(i);
        } else {
            D[bot + 1] = (Point2d)this.points.get(i);
            D[bot + 2] = (Point2d)this.points.get(0);
        }
        i += 2;
        while (i < n) {
            if (!(this.isLeft(D[bot], D[bot + 1], (Point2d)this.points.get(i)) > 0.0f) || !(this.isLeft(D[top - 1], D[top], (Point2d)this.points.get(i)) > 0.0f)) {
                while (this.isLeft(D[bot], D[bot + 1], (Point2d)this.points.get(i)) <= 0.0f) {
                    ++bot;
                }
                D[--bot] = (Point2d)this.points.get(i);
                while (this.isLeft(D[top - 1], D[top], (Point2d)this.points.get(i)) <= 0.0f) {
                    --top;
                }
                D[++top] = (Point2d)this.points.get(i);
            }
            ++i;
        }
        Polygon H = new Polygon();
        List<Point2d> vertices = H.getVertices();
        for (int h = 0; h <= top - bot; ++h) {
            vertices.add(D[bot + h]);
        }
        return H;
    }

    private float isLeft(Point2d P0, Point2d P1, Point2d P2) {
        return (P1.getX() - P0.getX()) * (P2.getY() - P0.getY()) - (P2.getX() - P0.getX()) * (P1.getY() - P0.getY());
    }

    @Override
    public RotatedRectangle minimumBoundingRectangle() {
        return RotatingCalipers.getMinimumBoundingRectangle(this, false);
    }

    public RotatedRectangle minimumBoundingRectangle(boolean assumeSimple) {
        return RotatingCalipers.getMinimumBoundingRectangle(this, assumeSimple);
    }

    public Point2d closestPoint(Point2d pt) {
        boolean closed = this.isClosed();
        if (!closed) {
            this.close();
        }
        float x = pt.getX();
        float y = pt.getY();
        float minDist = Float.MAX_VALUE;
        Point2dImpl min = new Point2dImpl();
        Point2dImpl tpt = new Point2dImpl();
        for (int k = 0; k < this.points.size() - 1; ++k) {
            float wy;
            float vx = ((Point2d)this.points.get(k)).getX();
            float vy = ((Point2d)this.points.get(k)).getY();
            float wx = ((Point2d)this.points.get(k + 1)).getX();
            float l2 = (wx - vx) * (wx - vx) + ((wy = ((Point2d)this.points.get(k + 1)).getY()) - vy) * (wy - vy);
            if ((double)l2 == 0.0) {
                tpt.x = vx;
                tpt.y = vy;
            } else {
                float t = ((x - vx) * (wx - vx) + (y - vy) * (wy - vy)) / l2;
                if ((double)t < 0.0) {
                    tpt.x = vx;
                    tpt.y = vy;
                } else if ((double)t > 1.0) {
                    tpt.x = wx;
                    tpt.y = wy;
                } else {
                    tpt.x = vx + t * (wx - vx);
                    tpt.y = vy + t * (wy - vy);
                }
            }
            float dist = (float)Line2d.distance(x, y, tpt.x, tpt.y);
            if (!(dist < minDist)) continue;
            minDist = dist;
            min.x = tpt.x;
            min.y = tpt.y;
        }
        if (!closed) {
            this.open();
        }
        return min;
    }
}

