/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.MatrixTransformProvider;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.function.Predicate;
import org.openimaj.util.pair.IndependentPair;

public class AffineTransformModel
implements EstimatableModel<Point2d, Point2d>,
MatrixTransformProvider {
    protected Predicate<AffineTransformModel> modelCheck;
    protected Matrix transform;

    public AffineTransformModel() {
        this.transform = new Matrix(3, 3);
        this.transform.set(2, 0, 0.0);
        this.transform.set(2, 1, 0.0);
        this.transform.set(2, 2, 1.0);
    }

    public AffineTransformModel(Predicate<AffineTransformModel> mc) {
        this.modelCheck = mc;
        this.transform = new Matrix(3, 3);
        this.transform.set(2, 0, 0.0);
        this.transform.set(2, 1, 0.0);
        this.transform.set(2, 2, 1.0);
    }

    public AffineTransformModel clone() {
        AffineTransformModel atm = new AffineTransformModel();
        atm.modelCheck = this.modelCheck;
        atm.transform = this.transform.copy();
        return atm;
    }

    @Override
    public Matrix getTransform() {
        return this.transform;
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Point2d, Point2d>> data) {
        if (data.size() < this.numItemsToEstimate()) {
            return false;
        }
        this.transform = TransformUtilities.affineMatrix(data);
        if (this.modelCheck == null) {
            return true;
        }
        return this.modelCheck.test(this);
    }

    @Override
    public Point2d predict(Point2d p) {
        return p.transform(this.transform);
    }

    @Override
    public int numItemsToEstimate() {
        return 3;
    }

    public String toString() {
        double[][] mat;
        String str = "";
        double[][] dArray = mat = this.transform.getArray();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] r;
            for (double v : r = dArray[i]) {
                str = str + " " + v;
            }
            str = str + "\n";
        }
        return str;
    }
}

