/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point3d;
import org.openimaj.math.geometry.transforms.AffineTransformModel3d;
import org.openimaj.math.geometry.transforms.MatrixTransformProvider;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.util.pair.IndependentPair;

public class RigidTransformModel3d
extends AffineTransformModel3d
implements MatrixTransformProvider {
    @Override
    public RigidTransformModel3d clone() {
        RigidTransformModel3d atm = new RigidTransformModel3d();
        atm.transform = this.transform.copy();
        return atm;
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Point3d, Point3d>> data) {
        this.transform = TransformUtilities.rigidMatrix(data);
        try {
            this.transform.inverse();
        }
        catch (RuntimeException e) {
            this.transform = Matrix.identity(4, 4);
        }
        return true;
    }

    @Override
    public int numItemsToEstimate() {
        return 6;
    }
}

