/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.residuals;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.MatrixTransformProvider;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.util.pair.IndependentPair;

public class AlgebraicResidual2d<M extends Model<Point2d, Point2d> & MatrixTransformProvider>
implements ResidualCalculator<Point2d, Point2d, M> {
    private Matrix transform;

    @Override
    public void setModel(M model) {
        this.transform = ((MatrixTransformProvider)model).getTransform();
        if (this.transform.getRowDimension() != 3 || this.transform.getColumnDimension() != 3) {
            throw new IllegalArgumentException("Transform matrix must be 3x3");
        }
    }

    @Override
    public double computeResidual(IndependentPair<Point2d, Point2d> data) {
        Point2d p1 = data.getFirstObject();
        Point2d p2 = data.getSecondObject();
        float x = p1.getX();
        float y = p1.getY();
        float X = p2.getX();
        float Y = p2.getY();
        double h11 = this.transform.get(0, 0);
        double h12 = this.transform.get(0, 1);
        double h13 = this.transform.get(0, 2);
        double h21 = this.transform.get(1, 0);
        double h22 = this.transform.get(1, 1);
        double h23 = this.transform.get(1, 2);
        double h31 = this.transform.get(2, 0);
        double h32 = this.transform.get(2, 1);
        double h33 = this.transform.get(2, 2);
        double s1 = (double)x * h11 + (double)y * h12 + h13 - (double)(x * X) * h31 - (double)(y * X) * h32 - (double)X * h33;
        double s2 = (double)x * h21 + (double)y * h22 + h23 - (double)(x * Y) * h31 - (double)(y * Y) * h32 - (double)Y * h33;
        return s1 * s1 + s2 * s2;
    }

    @Override
    public void computeResiduals(List<? extends IndependentPair<Point2d, Point2d>> data, double[] residuals) {
        for (int i = 0; i < data.size(); ++i) {
            residuals[i] = this.computeResidual(data.get(i));
        }
    }
}

