/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.residuals;

import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.util.pair.IndependentPair;

public class SingleImageTransferResidual2d<M extends Model<Point2d, Point2d>>
implements ResidualCalculator<Point2d, Point2d, M> {
    M model;

    @Override
    public void setModel(M model) {
        this.model = model;
    }

    @Override
    public double computeResidual(IndependentPair<Point2d, Point2d> data) {
        Point2d p2_est = (Point2d)this.model.predict((Point2d)data.firstObject());
        float dx = data.secondObject().getX() - p2_est.getX();
        float dy = data.secondObject().getY() - p2_est.getY();
        return dx * dx + dy * dy;
    }

    @Override
    public void computeResiduals(List<? extends IndependentPair<Point2d, Point2d>> data, double[] errors) {
        for (int i = 0; i < data.size(); ++i) {
            Point2d p2_est = (Point2d)this.model.predict((Point2d)data.get(i).firstObject());
            Point2d so = data.get(i).secondObject();
            float dx = so.getX() - p2_est.getX();
            float dy = so.getY() - p2_est.getY();
            errors[i] = dx * dx + dy * dy;
        }
    }
}

