/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.triangulation;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;

public class Voronoi {
    private Voronoi() {
    }

    public static Graph<Point2d, DefaultEdge> computeVoronoiGraph(List<? extends Point2d> points) {
        double[] wh = Voronoi.computeWidthHeight(points);
        return Voronoi.computeVoronoiGraph(points, wh[0], wh[1]);
    }

    public static Graph<Point2d, DefaultEdge> computeVoronoiGraph(List<? extends Point2d> points, double width, double height) {
        FortunesAlgorithm f = new FortunesAlgorithm(width, height);
        List<Line2d> edges = f.runFortune(points);
        SimpleGraph<Point2d, DefaultEdge> graph = new SimpleGraph<Point2d, DefaultEdge>(DefaultEdge.class);
        for (Line2d l : edges) {
            graph.addEdge(l.begin, l.end);
        }
        return graph;
    }

    public static List<Line2d> computeVoronoiEdges(List<? extends Point2d> points) {
        double[] wh = Voronoi.computeWidthHeight(points);
        return Voronoi.computeVoronoiEdges(points, wh[0], wh[1]);
    }

    public static List<Line2d> computeVoronoiEdges(List<? extends Point2d> points, double width, double height) {
        FortunesAlgorithm f = new FortunesAlgorithm(width, height);
        return f.runFortune(points);
    }

    private static double[] computeWidthHeight(List<? extends Point2d> points) {
        float maxx = -3.4028235E38f;
        float minx = Float.MAX_VALUE;
        float maxy = -3.4028235E38f;
        float miny = Float.MAX_VALUE;
        for (Point2d point2d : points) {
            float x = point2d.getX();
            float y = point2d.getY();
            if (maxx < x) {
                maxx = x;
            }
            if (minx > x) {
                minx = x;
            }
            if (maxy < y) {
                maxy = y;
            }
            if (!(miny > y)) continue;
            miny = y;
        }
        float w = maxx - minx;
        float f = maxy - miny;
        return new double[]{(double)maxx + 0.1 * (double)w, (double)maxy + 0.1 * (double)f};
    }

    private static class FortunesAlgorithm {
        private List<Line2d> output = new ArrayList<Line2d>();
        private PriorityQueue<Point2d> sites = new PriorityQueue();
        private PriorityQueue<CircleEvent> events = new PriorityQueue();
        private Arc root;
        private double height;
        private double width;

        FortunesAlgorithm(double width, double height) {
            this.width = width;
            this.height = height;
        }

        List<Line2d> runFortune(List<? extends Point2d> points) {
            for (Point2d point2d : points) {
                this.sites.add(new ComparablePoint(point2d));
            }
            while (this.sites.size() > 0) {
                if (this.events.size() > 0 && this.events.peek().xpos <= (double)((ComparablePoint)this.sites.peek()).x) {
                    this.processCircleEvent(this.events.poll());
                    continue;
                }
                this.frontInsert((ComparablePoint)this.sites.poll());
            }
            while (this.events.size() > 0) {
                this.processCircleEvent(this.events.poll());
            }
            this.finishEdges();
            return this.output;
        }

        private void processCircleEvent(CircleEvent event) {
            if (event.valid) {
                Edge edgy = new Edge(event.p);
                Arc parc = event.a;
                if (parc.prev != null) {
                    parc.prev.next = parc.next;
                    parc.prev.edge1 = edgy;
                }
                if (parc.next != null) {
                    parc.next.prev = parc.prev;
                    parc.next.edge0 = edgy;
                }
                if (parc.edge0 != null) {
                    parc.edge0.finish(event.p);
                }
                if (parc.edge1 != null) {
                    parc.edge1.finish(event.p);
                }
                if (parc.prev != null) {
                    this.checkCircleEvent(parc.prev, event.xpos);
                }
                if (parc.next != null) {
                    this.checkCircleEvent(parc.next, event.xpos);
                }
            }
        }

        void frontInsert(ComparablePoint focus) {
            if (this.root == null) {
                this.root = new Arc(focus);
                return;
            }
            Arc parc = this.root;
            while (parc != null) {
                CircleResultPack rez = this.intersect(focus, parc);
                if (rez.valid) {
                    if (parc.next != null) {
                        CircleResultPack rezz = this.intersect(focus, parc.next);
                        if (!rezz.valid) {
                            Arc bla = new Arc(parc.focus);
                            bla.prev = parc;
                            bla.next = parc.next;
                            parc.next.prev = bla;
                            parc.next = bla;
                        }
                    } else {
                        parc.next = new Arc(parc.focus);
                        parc.next.prev = parc;
                    }
                    parc.next.edge1 = parc.edge1;
                    Arc bla = new Arc(focus);
                    bla.prev = parc;
                    bla.next = parc.next;
                    parc.next.prev = bla;
                    parc = parc.next = bla;
                    parc.prev.edge1 = parc.edge0 = new Edge(rez.center);
                    parc.next.edge0 = parc.edge1 = new Edge(rez.center);
                    this.checkCircleEvent(parc, focus.x);
                    this.checkCircleEvent(parc.prev, focus.x);
                    this.checkCircleEvent(parc.next, focus.x);
                    return;
                }
                parc = parc.next;
            }
            parc = this.root;
            while (parc.next != null) {
                parc = parc.next;
            }
            parc.next = new Arc(focus);
            parc.next.prev = parc;
            ComparablePoint start = new ComparablePoint(0.0, (parc.next.focus.y + parc.focus.y) / 2.0f);
            parc.edge1 = parc.next.edge0 = new Edge(start);
        }

        void checkCircleEvent(Arc parc, double xpos) {
            if (parc.event != null && parc.event.xpos != xpos) {
                parc.event.valid = false;
            }
            parc.event = null;
            if (parc.prev == null || parc.next == null) {
                return;
            }
            CircleResultPack result = this.circle(parc.prev.focus, parc.focus, parc.next.focus);
            if (result.valid && result.rightmostX > xpos) {
                parc.event = new CircleEvent(result.rightmostX, result.center, parc);
                this.events.offer(parc.event);
            }
        }

        CircleResultPack circle(ComparablePoint a, ComparablePoint b, ComparablePoint c) {
            ComparablePoint o;
            CircleResultPack result = new CircleResultPack();
            if ((b.x - a.x) * (c.y - a.y) - (c.x - a.x) * (b.y - a.y) > 0.0f) {
                result.valid = false;
                return result;
            }
            double A = b.x - a.x;
            double B = b.y - a.y;
            double C = c.x - a.x;
            double D = c.y - a.y;
            double E = A * (double)(a.x + b.x) + B * (double)(a.y + b.y);
            double F = C * (double)(a.x + c.x) + D * (double)(a.y + c.y);
            double G = 2.0 * (A * (double)(c.y - b.y) - B * (double)(c.x - b.x));
            if (G == 0.0) {
                result.valid = false;
                return result;
            }
            result.center = o = new ComparablePoint((D * E - B * F) / G, (A * F - C * E) / G);
            result.rightmostX = (double)o.x + Math.sqrt(Math.pow(a.x - o.x, 2.0) + Math.pow(a.y - o.y, 2.0));
            result.valid = true;
            return result;
        }

        CircleResultPack intersect(ComparablePoint p, Arc i) {
            CircleResultPack res = new CircleResultPack();
            res.valid = false;
            if (i.focus.x == p.x) {
                return res;
            }
            double a = 0.0;
            double b = 0.0;
            if (i.prev != null) {
                a = this.intersection((ComparablePoint)i.prev.focus, (ComparablePoint)i.focus, (double)((double)p.x)).y;
            }
            if (i.next != null) {
                b = this.intersection((ComparablePoint)i.focus, (ComparablePoint)i.next.focus, (double)((double)p.x)).y;
            }
            if ((i.prev == null || a <= (double)p.y) && (i.next == null || (double)p.y <= b)) {
                res.center = new ComparablePoint(0.0, p.y);
                res.center.x = (i.focus.x * i.focus.x + (i.focus.y - res.center.y) * (i.focus.y - res.center.y) - p.x * p.x) / (2.0f * i.focus.x - 2.0f * p.x);
                res.valid = true;
                return res;
            }
            return res;
        }

        ComparablePoint intersection(ComparablePoint p0, ComparablePoint p1, double l) {
            ComparablePoint res = new ComparablePoint(0.0, 0.0);
            ComparablePoint p = p0;
            if (p0.x == p1.x) {
                res.y = (p0.y + p1.y) / 2.0f;
            } else if ((double)p1.x == l) {
                res.y = p1.y;
            } else if ((double)p0.x == l) {
                res.y = p0.y;
                p = p1;
            } else {
                double z0 = 2.0 * ((double)p0.x - l);
                double z1 = 2.0 * ((double)p1.x - l);
                double a = 1.0 / z0 - 1.0 / z1;
                double b = -2.0 * ((double)p0.y / z0 - (double)p1.y / z1);
                double c = ((double)(p0.y * p0.y + p0.x * p0.x) - l * l) / z0 - ((double)(p1.y * p1.y + p1.x * p1.x) - l * l) / z1;
                res.y = (float)((-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a));
            }
            res.x = (float)(((double)(p.x * p.x + (p.y - res.y) * (p.y - res.y)) - l * l) / ((double)(2.0f * p.x) - 2.0 * l));
            return res;
        }

        void finishEdges() {
            double l = this.width * 2.0 + this.height;
            Arc i = this.root;
            while (i != null) {
                if (i.edge1 != null) {
                    i.edge1.finish(this.intersection(i.focus, i.next.focus, l * 2.0));
                }
                i = i.next;
            }
        }

        private static class CircleResultPack {
            boolean valid;
            ComparablePoint center;
            double rightmostX;

            private CircleResultPack() {
            }
        }

        private static class Arc {
            ComparablePoint focus;
            Arc next;
            Arc prev;
            CircleEvent event;
            Edge edge0;
            Edge edge1;

            Arc(ComparablePoint p) {
                this.focus = p;
                this.next = null;
                this.prev = null;
                this.event = null;
                this.edge0 = null;
                this.edge1 = null;
            }
        }

        private class Edge
        extends Line2d {
            boolean done;

            Edge(ComparablePoint p) {
                this.begin = p;
                this.end = new ComparablePoint(0.0, 0.0);
                this.done = false;
                FortunesAlgorithm.this.output.add(this);
            }

            void finish(ComparablePoint p) {
                if (this.done) {
                    return;
                }
                this.end = p;
                this.done = true;
            }
        }

        private static class CircleEvent
        implements Comparable<CircleEvent> {
            double xpos;
            ComparablePoint p;
            Arc a;
            boolean valid;

            CircleEvent(double X, ComparablePoint P, Arc A) {
                this.xpos = X;
                this.a = A;
                this.p = P;
                this.valid = true;
            }

            @Override
            public int compareTo(CircleEvent foo) {
                return Double.valueOf(this.xpos).compareTo(foo.xpos);
            }
        }

        class ComparablePoint
        extends Point2dImpl
        implements Comparable<ComparablePoint> {
            public ComparablePoint(double X, double Y) {
                this.x = (float)X;
                this.y = (float)Y;
            }

            public ComparablePoint(Point2d pt) {
                this.x = pt.getX();
                this.y = pt.getY();
            }

            @Override
            public int compareTo(ComparablePoint foo) {
                return Float.valueOf(this.x).compareTo(Float.valueOf(foo.x));
            }
        }
    }
}

