/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import Jama.Matrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.pair.IndependentPair;

public class GeneralisedEigenvalueProblem {
    private static final int sygvd(int itype, String jobz, String uplo, DenseMatrix A, DenseMatrix B, DenseVector W) {
        int info = GeneralisedEigenvalueProblem.dsygvd(itype, jobz, uplo, A.numColumns(), A.getData(), A.numRows(), B.getData(), B.numRows(), W.getData());
        if (info == 0) {
            return 0;
        }
        if (info < 0) {
            throw new IllegalArgumentException("LAPACK ERROR: DSYGVD returned " + info);
        }
        throw new RuntimeException("LAPACK ERROR: DSYGVD returned " + info);
    }

    private static final int dsygvd(int itype, String jobz, String uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w) {
        double[] work = new double[1];
        double[] tmp = new double[1];
        intW info = new intW(-1);
        int[] iwork = new int[1];
        LAPACK.getInstance().dsygvd(itype, jobz, uplo, n, tmp, lda, tmp, ldb, tmp, work, -1, iwork, 0, info);
        if (info.val != 0) {
            return info.val;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        LAPACK.getInstance().dsygvd(itype, jobz, uplo, n, a, lda, b, ldb, w, work, lwork, iwork, liwork, info);
        return info.val;
    }

    public static DenseVector symmetricGeneralisedEigenvalues(DenseMatrix A, DenseMatrix B) {
        if (!A.isSquare() || !B.isSquare()) {
            throw new IllegalArgumentException("Input matrices must be square");
        }
        DenseVector W = new DenseVector(A.numRows());
        GeneralisedEigenvalueProblem.sygvd(1, "N", "U", A.copy(), B.copy(), W);
        return W;
    }

    public static IndependentPair<DenseMatrix, DenseVector> symmetricGeneralisedEigenvectors(DenseMatrix A, DenseMatrix B) {
        if (!A.isSquare() || !B.isSquare()) {
            throw new IllegalArgumentException("Input matrices must be square");
        }
        DenseMatrix vecs = A.copy();
        DenseVector W = new DenseVector(A.numRows());
        GeneralisedEigenvalueProblem.sygvd(1, "V", "U", vecs, B.copy(), W);
        return new IndependentPair<DenseMatrix, DenseVector>(vecs, W);
    }

    public static double[] symmetricGeneralisedEigenvalues(Matrix A, Matrix B) {
        if (A.getRowDimension() != A.getColumnDimension() || B.getRowDimension() != B.getColumnDimension()) {
            throw new IllegalArgumentException("Input matrices must be square");
        }
        DenseVector W = new DenseVector(A.getRowDimension());
        GeneralisedEigenvalueProblem.sygvd(1, "N", "U", new DenseMatrix(A.getArray()), new DenseMatrix(B.getArray()), W);
        return W.getData();
    }

    public static IndependentPair<Matrix, double[]> symmetricGeneralisedEigenvectors(Matrix A, Matrix B) {
        if (A.getRowDimension() != A.getColumnDimension() || B.getRowDimension() != B.getColumnDimension()) {
            throw new IllegalArgumentException("Input matrices must be square");
        }
        int dim = A.getRowDimension();
        DenseMatrix vecs = new DenseMatrix(A.getArray());
        DenseVector W = new DenseVector(dim);
        GeneralisedEigenvalueProblem.sygvd(1, "V", "U", vecs, new DenseMatrix(B.getArray()), W);
        Matrix evecs = new Matrix(dim, dim);
        double[][] evecsData = evecs.getArray();
        double[] vecsData = vecs.getData();
        for (int r = 0; r < dim; ++r) {
            for (int c = 0; c < dim; ++c) {
                evecsData[r][c] = vecsData[r + c * dim];
            }
        }
        return new IndependentPair<Matrix, double[]>(evecs, W.getData());
    }

    public static IndependentPair<Matrix, double[]> symmetricGeneralisedEigenvectorsSorted(Matrix A, Matrix B) {
        if (A.getRowDimension() != A.getColumnDimension() || B.getRowDimension() != B.getColumnDimension()) {
            throw new IllegalArgumentException("Input matrices must be square");
        }
        int dim = A.getRowDimension();
        DenseMatrix vecs = new DenseMatrix(A.getArray());
        DenseVector W = new DenseVector(dim);
        GeneralisedEigenvalueProblem.sygvd(1, "V", "U", vecs, new DenseMatrix(B.getArray()), W);
        Matrix evecs = new Matrix(dim, dim);
        double[][] evecsData = evecs.getArray();
        double[] vecsData = vecs.getData();
        double[] valsData = W.getData();
        int[] indices = ArrayUtils.range(0, valsData.length - 1);
        ArrayUtils.parallelQuicksortDescending(valsData, indices);
        for (int r = 0; r < dim; ++r) {
            for (int c = 0; c < dim; ++c) {
                evecsData[r][c] = vecsData[r + indices[c] * dim];
            }
        }
        return new IndependentPair<Matrix, double[]>(evecs, valsData);
    }

    public static IndependentPair<Matrix, double[]> symmetricGeneralisedEigenvectorsSorted(Matrix A, Matrix B, int numVecs) {
        if (A.getRowDimension() != A.getColumnDimension() || B.getRowDimension() != B.getColumnDimension()) {
            throw new IllegalArgumentException("Input matrices must be square");
        }
        int dim = A.getRowDimension();
        DenseMatrix vecs = new DenseMatrix(A.getArray());
        DenseVector W = new DenseVector(dim);
        GeneralisedEigenvalueProblem.sygvd(1, "V", "U", vecs, new DenseMatrix(B.getArray()), W);
        Matrix evecs = new Matrix(dim, numVecs);
        double[][] evecsData = evecs.getArray();
        double[] vecsData = vecs.getData();
        double[] valsData = W.getData();
        int[] indices = ArrayUtils.range(0, valsData.length - 1);
        ArrayUtils.parallelQuicksortDescending(valsData, indices);
        for (int r = 0; r < dim; ++r) {
            for (int c = 0; c < numVecs; ++c) {
                evecsData[r][c] = vecsData[r + indices[c] * dim];
            }
        }
        return new IndependentPair<Matrix, double[]>(evecs, valsData);
    }
}

