/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import Jama.Matrix;
import java.util.Arrays;

public class JamaDenseMatrix
extends ch.akuhn.matrix.Matrix {
    public Matrix matrix;

    public JamaDenseMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public JamaDenseMatrix(double[][] values) {
        this.matrix = new Matrix(values);
        this.assertInvariant();
    }

    protected void assertInvariant() throws IllegalArgumentException {
        if (this.matrix.getArray().length == 0) {
            return;
        }
        int m = this.matrix.getArray()[0].length;
        for (int n = 0; n < this.matrix.getArray().length; ++n) {
            if (this.matrix.getArray()[n].length == m) continue;
            throw new IllegalArgumentException();
        }
    }

    public JamaDenseMatrix(int rows, int columns) {
        this.matrix = new Matrix(rows, columns);
    }

    @Override
    public double add(int row, int column, double value) {
        double[] dArray = this.matrix.getArray()[row];
        int n = column;
        double d = dArray[n] + value;
        dArray[n] = d;
        return d;
    }

    @Override
    public int columnCount() {
        return this.matrix.getColumnDimension();
    }

    @Override
    public double get(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public double put(int row, int column, double value) {
        this.matrix.set(row, column, value);
        return value;
    }

    @Override
    public int rowCount() {
        return this.matrix.getRowDimension();
    }

    @Override
    public int used() {
        throw null;
    }

    @Override
    public double[][] unwrap() {
        return this.matrix.getArray();
    }

    public void fill(double constant) {
        for (double[] row : this.matrix.getArray()) {
            Arrays.fill(row, constant);
        }
    }

    public void applyMultiplication(double d) {
        this.matrix.timesEquals(d);
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public double[][] asArray() {
        return this.matrix.getArray();
    }

    @Override
    public ch.akuhn.matrix.Matrix newInstance(int rows, int cols) {
        return new JamaDenseMatrix(rows, cols);
    }
}

