/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;
import org.openimaj.math.matrix.EigenValueVectorPair;
import org.openimaj.math.matrix.PseudoInverse;

public class MatrixUtils {
    private MatrixUtils() {
    }

    public static boolean anyNaNorInf(Matrix matrix) {
        double[][] dArray = matrix.getArray();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] arrLine;
            for (double d : arrLine = dArray[i]) {
                if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                return true;
            }
        }
        return false;
    }

    public static double maxAbsDiag(Matrix matrix) {
        double max = -1.0;
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            double curr = Math.abs(matrix.get(i, i));
            if (!(max < curr)) continue;
            max = curr;
        }
        return max;
    }

    public static double minAbsDiag(Matrix matrix) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            double curr = Math.abs(matrix.get(i, i));
            if (!(min > curr)) continue;
            min = curr;
        }
        return min;
    }

    public static Matrix sqrt(Matrix matrix) {
        EigenvalueDecomposition evd = matrix.eig();
        Matrix v = evd.getV();
        Matrix d = evd.getD();
        for (int r = 0; r < d.getRowDimension(); ++r) {
            for (int c = 0; c < d.getColumnDimension(); ++c) {
                d.set(r, c, Math.sqrt(d.get(r, c)));
            }
        }
        Matrix a = v.inverse();
        Matrix b = v.times(d).inverse();
        return a.solve(b).inverse();
    }

    public static Matrix pseudoInverse(Matrix matrix) {
        return PseudoInverse.pseudoInverse(matrix);
    }

    public static Matrix invSqrtSym(Matrix matrix) {
        EigenvalueDecomposition evd = matrix.eig();
        Matrix v = evd.getV();
        Matrix d = evd.getD();
        for (int r = 0; r < d.getRowDimension(); ++r) {
            for (int c = 0; c < d.getColumnDimension(); ++c) {
                if (d.get(r, c) > 0.0) {
                    d.set(r, c, 1.0 / Math.sqrt(d.get(r, c)));
                    continue;
                }
                d.set(r, c, 0.0);
            }
        }
        return v.times(d).times(v.transpose());
    }

    public static Matrix abs(Matrix mat) {
        Matrix copy = mat.copy();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            for (int j = 0; j < mat.getColumnDimension(); ++j) {
                copy.set(i, j, Math.abs(mat.get(i, j)));
            }
        }
        return copy;
    }

    public static boolean equals(Matrix m1, Matrix m2, double eps) {
        double[][] a2;
        double[][] a1 = m1.getArray();
        if (a1.length != (a2 = m2.getArray()).length || a1[0].length != a2[0].length) {
            return false;
        }
        for (int r = 0; r < a1.length; ++r) {
            for (int c = 0; c < a1[r].length; ++c) {
                if (!(Math.abs(a1[r][c] - a2[r][c]) > eps)) continue;
                return false;
            }
        }
        return true;
    }

    public static Matrix pow(Matrix mat, double exp) {
        Matrix copy = mat.copy();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            for (int j = 0; j < mat.getColumnDimension(); ++j) {
                copy.set(i, j, Math.pow(mat.get(i, j), exp));
            }
        }
        return copy;
    }

    public static String toString(Matrix mat) {
        StringWriter matWriter = new StringWriter();
        mat.print(new PrintWriter(matWriter), 5, 5);
        return matWriter.getBuffer().toString();
    }

    public static double sum(Matrix mat) {
        double sum = 0.0;
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            for (int j = 0; j < mat.getColumnDimension(); ++j) {
                sum += mat.get(i, j);
            }
        }
        return sum;
    }

    public static void zero(Matrix m) {
        m.timesEquals(0.0);
    }

    public static EigenValueVectorPair symmetricEig2x2(Matrix m) {
        double secondEig;
        double b;
        double a = m.get(0, 0);
        double c = b = m.get(0, 1);
        double d = m.get(1, 1);
        double trace = a + d;
        double det = a * d - b * c;
        Matrix val = new Matrix(2, 2);
        double sqrtInner = trace * trace / 4.0 - det;
        if (sqrtInner < 0.0) {
            EigenvalueDecomposition e = m.eig();
            return new EigenValueVectorPair(e.getD(), e.getV());
        }
        double firstEig = trace / 2.0 + (sqrtInner = Math.sqrt(sqrtInner));
        if (firstEig > (secondEig = trace / 2.0 - sqrtInner)) {
            double tmp = firstEig;
            firstEig = secondEig;
            secondEig = tmp;
        }
        val.set(0, 0, firstEig);
        val.set(1, 1, secondEig);
        Matrix vec = new Matrix(2, 2);
        double v1 = firstEig - a;
        double v2 = secondEig - a;
        double norm1 = Math.sqrt(v1 * v1 + b * b);
        double norm2 = Math.sqrt(b * b + v2 * v2);
        vec.set(0, 0, b / norm1);
        vec.set(0, 1, b / norm2);
        vec.set(1, 0, v1 / norm1);
        vec.set(1, 1, v2 / norm2);
        vec.set(1, 0, vec.get(0, 1));
        EigenValueVectorPair ret = new EigenValueVectorPair(val, vec);
        return ret;
    }

    public static EigenValueVectorPair eig2x2(Matrix m) {
        double v1;
        double secondEig;
        if (m.getColumnDimension() != 2 || m.getRowDimension() != 2) {
            EigenvalueDecomposition e = m.eig();
            return new EigenValueVectorPair(e.getD(), e.getV());
        }
        double a = m.get(0, 0);
        double b = m.get(0, 1);
        double c = m.get(1, 0);
        double d = m.get(1, 1);
        double trace = a + d;
        double det = a * d - b * c;
        Matrix val = new Matrix(2, 2);
        double sqrtInner = trace * trace / 4.0 - det;
        if (sqrtInner < 0.0) {
            EigenvalueDecomposition e = m.eig();
            return new EigenValueVectorPair(e.getD(), e.getV());
        }
        double firstEig = trace / 2.0 + (sqrtInner = Math.sqrt(sqrtInner));
        if (firstEig > (secondEig = trace / 2.0 - sqrtInner)) {
            double tmp = firstEig;
            firstEig = secondEig;
            secondEig = tmp;
        }
        val.set(0, 0, firstEig);
        val.set(1, 1, secondEig);
        Matrix vec = new Matrix(2, 2);
        if (b == 0.0 && c == 0.0) {
            vec.set(0, 0, 1.0);
            vec.set(1, 1, 1.0);
        } else if (c != 0.0) {
            v1 = firstEig - d;
            double v2 = secondEig - d;
            double norm1 = Math.sqrt(v1 * v1 + c * c);
            double norm2 = Math.sqrt(c * c + v2 * v2);
            vec.set(0, 0, v1 / norm1);
            vec.set(0, 1, v2 / norm2);
            vec.set(1, 0, c / norm1);
            vec.set(1, 1, c / norm2);
        } else if (b != 0.0) {
            v1 = firstEig - a;
            double v2 = secondEig - a;
            double norm1 = Math.sqrt(v1 * v1 + b * b);
            double norm2 = Math.sqrt(b * b + v2 * v2);
            vec.set(0, 0, b / norm1);
            vec.set(0, 1, b / norm2);
            vec.set(1, 0, v1 / norm1);
            vec.set(1, 1, v2 / norm2);
        }
        EigenValueVectorPair ret = new EigenValueVectorPair(val, vec);
        return ret;
    }

    public static Matrix matrixFromFloat(float[][] data) {
        Matrix out = new Matrix(data.length, data[0].length);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                out.set(i, j, data[i][j]);
            }
        }
        return out;
    }

    public static Matrix reduceRank(Matrix m, int rank) {
        SVD svd;
        if (rank > Math.min(m.getColumnDimension(), m.getRowDimension())) {
            return m;
        }
        DenseMatrix mjtA = new DenseMatrix(m.getArray());
        try {
            svd = SVD.factorize(mjtA);
        }
        catch (NotConvergedException e) {
            throw new RuntimeException(e);
        }
        DenseMatrix U = svd.getU();
        DenseMatrix Vt = svd.getVt();
        double[] svector = svd.getS();
        DenseMatrix S = new DenseMatrix(U.numColumns(), Vt.numRows());
        for (int i = 0; i < rank; ++i) {
            S.set(i, i, svector[i]);
        }
        DenseMatrix C = new DenseMatrix(U.numRows(), S.numColumns());
        DenseMatrix out = new DenseMatrix(C.numRows(), Vt.numColumns());
        U.mult(S, C);
        C.mult(Vt, out);
        Matrix outFinal = MatrixUtils.convert(out);
        return outFinal;
    }

    public static Matrix convert(DenseMatrix mjt) {
        return MatrixUtils.convert(mjt, mjt.numRows(), mjt.numColumns());
    }

    public static Matrix convert(DenseMatrix mjt, int nrows, int ncols) {
        double[][] d = new double[nrows][ncols];
        double[] mjtd = mjt.getData();
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                d[r][c] = mjtd[r + c * d.length];
            }
        }
        return new Matrix(d);
    }

    public static Matrix reverseColumns(Matrix m) {
        return MatrixUtils.reverseColumnsInplace(m.copy());
    }

    public static Matrix reverseColumnsInplace(Matrix m) {
        double[][] data = m.getArray();
        int rows = data.length;
        int cols = data[0].length;
        int halfCols = cols / 2;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < halfCols; ++c) {
                double tmp = data[r][c];
                data[r][c] = data[r][cols - c - 1];
                data[r][cols - c - 1] = tmp;
            }
        }
        return m;
    }

    public static Matrix reverseRows(Matrix m) {
        return MatrixUtils.reverseRowsInplace(m.copy());
    }

    public static Matrix reverseRowsInplace(Matrix m) {
        double[][] data = m.getArray();
        int rows = data.length;
        int halfRows = rows / 2;
        for (int r = 0; r < halfRows; ++r) {
            double[] tmp = data[r];
            data[r] = data[rows - r - 1];
            data[rows - r - 1] = tmp;
        }
        return m;
    }

    public static Matrix diag(double[] s) {
        Matrix r = new Matrix(s.length, s.length);
        for (int i = 0; i < s.length; ++i) {
            r.set(i, i, s[i]);
        }
        return r;
    }

    public static Matrix setColumn(Matrix m, int c, double v) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        for (int r = 0; r < rows; ++r) {
            data[r][c] = v;
        }
        return m;
    }

    public static Matrix setRow(Matrix m, int r, double v) {
        double[][] data = m.getArray();
        int cols = m.getColumnDimension();
        for (int c = 0; c < cols; ++c) {
            data[r][c] = v;
        }
        return m;
    }

    public static Matrix fill(Matrix m, double v) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = v;
            }
        }
        return m;
    }

    public static Matrix minus(Matrix m, double v) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int r = 0; r < rows; ++r) {
            int c = 0;
            while (c < cols) {
                double[] dArray = data[r];
                int n = c++;
                dArray[n] = dArray[n] - v;
            }
        }
        return m;
    }

    public static Matrix plus(Matrix m, double v) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int r = 0; r < rows; ++r) {
            int c = 0;
            while (c < cols) {
                double[] dArray = data[r];
                int n = c++;
                dArray[n] = dArray[n] + v;
            }
        }
        return m;
    }

    public static Matrix reshape(Matrix m, int newRows) {
        int oldCols = m.getColumnDimension();
        int length = oldCols * m.getRowDimension();
        int newCols = length / newRows;
        Matrix mat = new Matrix(newRows, newCols);
        double[][] m1v = m.getArray();
        double[][] m2v = mat.getArray();
        int r1 = 0;
        int r2 = 0;
        int c1 = 0;
        int c2 = 0;
        for (int i = 0; i < length; ++i) {
            m2v[r2][c2] = m1v[r1][c1];
            if (++c1 >= oldCols) {
                c1 = 0;
                ++r1;
            }
            if (++c2 < newCols) continue;
            c2 = 0;
            ++r2;
        }
        return mat;
    }

    public static Matrix reshape(Matrix m, int newRows, boolean columnMajor) {
        int oldCols = m.getColumnDimension();
        int oldRows = m.getRowDimension();
        int length = oldCols * m.getRowDimension();
        int newCols = length / newRows;
        Matrix mat = new Matrix(newRows, newCols);
        double[][] m1v = m.getArray();
        double[][] m2v = mat.getArray();
        int r1 = 0;
        int r2 = 0;
        int c1 = 0;
        int c2 = 0;
        if (!columnMajor) {
            for (int i = 0; i < length; ++i) {
                m2v[r2][c2] = m1v[r1][c1];
                if (++c1 >= oldCols) {
                    c1 = 0;
                    ++r1;
                }
                if (++c2 < newCols) continue;
                c2 = 0;
                ++r2;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                m2v[r2][c2] = m1v[r1][c1];
                if (++r1 >= oldRows) {
                    r1 = 0;
                    ++c1;
                }
                if (++r2 < newRows) continue;
                r2 = 0;
                ++c2;
            }
        }
        return mat;
    }

    public static double sumColumn(Matrix m, int col) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        double sum = 0.0;
        for (int r = 0; r < rows; ++r) {
            sum += data[r][col];
        }
        return sum;
    }

    public static double sumRow(Matrix m, int row) {
        double[][] data = m.getArray();
        int cols = m.getColumnDimension();
        double sum = 0.0;
        for (int c = 0; c < cols; ++c) {
            sum += data[row][c];
        }
        return sum;
    }

    public static Matrix incrColumn(Matrix m, int col, double value) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        for (int r = 0; r < rows; ++r) {
            double[] dArray = data[r];
            int n = col;
            dArray[n] = dArray[n] + value;
        }
        return m;
    }

    public static Matrix incrRow(Matrix m, int row, double value) {
        double[][] data = m.getArray();
        int cols = m.getColumnDimension();
        int c = 0;
        while (c < cols) {
            double[] dArray = data[row];
            int n = c++;
            dArray[n] = dArray[n] + value;
        }
        return m;
    }

    public static Matrix round(Matrix times) {
        double[][] data = times.getArray();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = Math.round(data[i][j]);
            }
        }
        return times;
    }

    public static Matrix min(Matrix A, Matrix B) {
        double[][] dataA = A.getArray();
        double[][] dataB = B.getArray();
        Matrix ret = A.copy();
        double[][] dataRet = ret.getArray();
        for (int i = 0; i < dataA.length; ++i) {
            for (int j = 0; j < dataB[i].length; ++j) {
                dataRet[i][j] = Math.min(dataA[i][j], dataB[i][j]);
            }
        }
        return ret;
    }

    public static Matrix rangePow(double d, double ... range) {
        double delta;
        double end;
        double start;
        if (range.length == 1) {
            start = 0.0;
            end = range[0];
            delta = 1.0;
        } else if (range.length == 2) {
            start = range[0];
            end = range[1];
            delta = 1.0;
        } else if (range.length == 3) {
            start = range[0];
            end = range[2];
            delta = range[1];
        } else {
            throw new RuntimeException("Invalid range options selected");
        }
        int l = (int)((end - start + 1.0) / delta);
        double[][] out = new double[1][l];
        for (int i = 0; i < l; ++i) {
            out[0][i] = Math.pow(d, start + (double)i * delta);
        }
        return new Matrix(out);
    }

    public static Matrix range(double ... range) {
        double delta;
        double end;
        double start;
        if (range.length == 1) {
            start = 0.0;
            end = range[0];
            delta = 1.0;
        } else if (range.length == 2) {
            start = range[0];
            end = range[1];
            delta = 1.0;
        } else if (range.length == 3) {
            start = range[0];
            end = range[2];
            delta = range[1];
        } else {
            throw new RuntimeException("Invalid range options selected");
        }
        int l = (int)Math.floor((end - start) / delta) + 1;
        double[][] out = new double[1][l];
        for (int i = 0; i < l; ++i) {
            out[0][i] = start + (double)i * delta;
        }
        return new Matrix(out);
    }

    public static Matrix range(int ... range) {
        int delta;
        int end;
        int start;
        if (range.length == 1) {
            start = 0;
            end = range[0];
            delta = 1;
        } else if (range.length == 2) {
            start = range[0];
            end = range[1];
            delta = 1;
        } else if (range.length == 3) {
            start = range[0];
            end = range[2];
            delta = range[1];
        } else {
            throw new RuntimeException("Invalid range options selected");
        }
        int l = (int)Math.floor((end - start) / delta) + 1;
        double[][] out = new double[1][l];
        for (int i = 0; i < l; ++i) {
            out[0][i] = start + i * delta;
        }
        return new Matrix(out);
    }

    public static Matrix ntuples(Matrix A, Matrix B) {
        double[][] Adata = A.getArray();
        double[][] Bdata = B.getArray();
        double[][] out = new double[2][Adata[0].length * Bdata[0].length];
        int i = 0;
        for (double a : Adata[0]) {
            for (double b : Bdata[0]) {
                out[0][i] = a;
                out[1][i] = b;
                ++i;
            }
        }
        return new Matrix(out);
    }

    public static Matrix repmat(Matrix x, int i, int j) {
        double[][] xdata = x.getArray();
        double[][] newmat = new double[xdata.length * i][xdata[0].length * j];
        for (int k = 0; k < newmat.length; k += xdata.length) {
            for (int l = 0; l < newmat[0].length; l += xdata[0].length) {
                int rowcopyindex = 0;
                for (double[] ds : xdata) {
                    System.arraycopy(ds, 0, newmat[k + rowcopyindex], l, xdata[0].length);
                    ++rowcopyindex;
                }
            }
        }
        return new Matrix(newmat);
    }

    public static Matrix hstack(Matrix ... x) {
        int height = x[0].getRowDimension();
        int width = 0;
        for (Matrix matrix : x) {
            width += matrix.getColumnDimension();
        }
        double[][] newmat = new double[height][width];
        int colindex = 0;
        for (Matrix matrix : x) {
            double[][] matdata = matrix.getArray();
            int w = matrix.getColumnDimension();
            for (int i = 0; i < height; ++i) {
                System.arraycopy(matdata[i], 0, newmat[i], colindex, w);
            }
            colindex += w;
        }
        return new Matrix(newmat);
    }

    public static Matrix plusEqualsRow(Matrix mat, Matrix rows, int[] rowIndex) {
        double[][] matdata = mat.getArray();
        double[][] rowdata = rows.getArray();
        int i = 0;
        for (int row : rowIndex) {
            for (int j = 0; j < rowdata[i].length; ++j) {
                double[] dArray = matdata[row];
                int n = j;
                dArray[n] = dArray[n] + rowdata[i][j];
            }
            ++i;
        }
        return mat;
    }

    public static Matrix lessThan(Matrix x, double val) {
        Matrix retMat = x.copy();
        double[][] data = x.getArray();
        double[][] retdata = retMat.getArray();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                retdata[i][j] = data[i][j] < val ? 1.0 : 0.0;
            }
        }
        return retMat;
    }

    public static Matrix greaterThan(Matrix x, double val) {
        Matrix retMat = x.copy();
        double[][] data = x.getArray();
        double[][] retdata = retMat.getArray();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                retdata[i][j] = data[i][j] > val ? 1.0 : 0.0;
            }
        }
        return retMat;
    }

    public static Matrix and(Matrix ... x) {
        Matrix retMat = MatrixUtils.ones(x[0].getRowDimension(), x[0].getColumnDimension());
        double[][] retdata = retMat.getArray();
        for (Matrix matrix : x) {
            double[][] data = matrix.getArray();
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    retdata[i][j] = retdata[i][j] != 0.0 && data[i][j] != 0.0 ? 1.0 : 0.0;
                }
            }
        }
        return retMat;
    }

    public static Matrix ones(int rowDimension, int columnDimension) {
        Matrix ret = new Matrix(rowDimension, columnDimension);
        return MatrixUtils.plus(ret, 1.0);
    }

    public static Matrix all(Matrix x) {
        int cols = x.getColumnDimension();
        int rows = x.getRowDimension();
        Matrix ret = new Matrix(1, cols);
        double[][] retdata = ret.getArray();
        double[][] data = x.getArray();
        for (int i = 0; i < cols; ++i) {
            boolean cool = true;
            for (int j = 0; j < rows; ++j) {
                boolean bl = cool = data[j][i] != 0.0 && cool;
                if (!cool) break;
            }
            retdata[0][i] = cool ? 1.0 : 0.0;
        }
        return ret;
    }

    public static int[] valsToIndex(double[] vals) {
        int nindex = 0;
        for (double d : vals) {
            nindex += d != 0.0 ? 1 : 0;
        }
        int[] indexes = new int[nindex];
        nindex = 0;
        int i = 0;
        for (double d : vals) {
            if (d != 0.0) {
                indexes[i] = nindex;
                ++i;
            }
            ++nindex;
        }
        return indexes;
    }

    public static Matrix greaterThanSet(Matrix x, int val, int toset) {
        double[][] data = x.getArray();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = data[i][j] > (double)val ? (double)toset : data[i][j];
            }
        }
        return x;
    }

    public static Matrix lessThanSet(Matrix x, int val, int toset) {
        double[][] data = x.getArray();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = data[i][j] < (double)val ? (double)toset : data[i][j];
            }
        }
        return x;
    }

    public static Matrix minusRow(Matrix in, double[] row) {
        Matrix out = in.copy();
        double[][] outData = out.getArray();
        int rows = out.getRowDimension();
        int cols = out.getColumnDimension();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double[] dArray = outData[r];
                int n = c;
                dArray[n] = dArray[n] - row[c];
            }
        }
        return out;
    }

    public static Matrix minusCol(Matrix in, Matrix col) {
        Matrix out = in.copy();
        double[][] outData = out.getArray();
        int rows = out.getRowDimension();
        int cols = out.getColumnDimension();
        double[][] colArr = col.getArray();
        for (int r = 0; r < rows; ++r) {
            int c = 0;
            while (c < cols) {
                double[] dArray = outData[r];
                int n = c++;
                dArray[n] = dArray[n] - colArr[r][0];
            }
        }
        return out;
    }

    public static Matrix plusEquals(Matrix result, Matrix add) {
        int rows = result.getRowDimension();
        int cols = result.getColumnDimension();
        double[][] resultData = result.getArray();
        double[][] addData = add.getArray();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double[] dArray = resultData[r];
                int n = c;
                dArray[n] = dArray[n] + addData[r][c];
            }
        }
        return result;
    }

    public static Matrix times(Matrix m, double val) {
        double[][] data = m.getArray();
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int r = 0; r < rows; ++r) {
            int c = 0;
            while (c < cols) {
                double[] dArray = data[r];
                int n = c++;
                dArray[n] = dArray[n] * val;
            }
        }
        return m;
    }

    public static double[][] mtjToDoubleArray(DenseMatrix mat) {
        double[][] out = new double[mat.numRows()][mat.numColumns()];
        double[] data = mat.getData();
        for (int r = 0; r < out.length; ++r) {
            double[] outr = out[r];
            for (int c = 0; c < out[0].length; ++c) {
                outr[c] = data[r + c * out.length];
            }
        }
        return out;
    }

    public static Matrix sumRows(Matrix m) {
        double[][] data = m.getArray();
        int cols = m.getColumnDimension();
        int rows = m.getRowDimension();
        Matrix sum = new Matrix(rows, 1);
        double[][] sumArr = sum.getArray();
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                double[] dArray = sumArr[r];
                dArray[0] = dArray[0] + data[r][c];
            }
        }
        return sum;
    }

    public static Matrix sumCols(Matrix m) {
        double[][] data = m.getArray();
        int cols = m.getColumnDimension();
        int rows = m.getRowDimension();
        Matrix sum = new Matrix(1, cols);
        double[][] sumArr = sum.getArray();
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                double[] dArray = sumArr[0];
                int n = c;
                dArray[n] = dArray[n] + data[r][c];
            }
        }
        return sum;
    }

    public static Matrix randGaussian(int rows, int cols) {
        Matrix m = new Matrix(rows, cols);
        double[][] d = m.getArray();
        Random r = new Random();
        for (int row = 0; row < d.length; ++row) {
            for (int col = 0; col < d[row].length; ++col) {
                d[row][col] = r.nextGaussian();
            }
        }
        return m;
    }

    public static double sparsity(SparseMatrix matrix) {
        double density = (double)matrix.used() / ((double)matrix.rowCount() * (double)matrix.columnCount());
        return 1.0 - density;
    }

    public static Matrix diag(Matrix cv) {
        Matrix d = new Matrix(cv.getRowDimension(), cv.getColumnDimension());
        for (int i = 0; i < Math.min(cv.getRowDimension(), cv.getColumnDimension()); ++i) {
            d.set(i, i, cv.get(i, i));
        }
        return d;
    }

    public static double[] diagVector(Matrix cv) {
        double[] d = new double[Math.min(cv.getRowDimension(), cv.getColumnDimension())];
        for (int i = 0; i < Math.min(cv.getRowDimension(), cv.getColumnDimension()); ++i) {
            d[i] = cv.get(i, i);
        }
        return d;
    }

    public static String toMatlabString(Matrix mat) {
        return "[" + MatrixUtils.toString(mat).trim().replace("\n ", ";").replace(" ", ",") + "]";
    }

    public static String toPythonString(Matrix mat) {
        return "[[" + MatrixUtils.toString(mat).trim().replace("\n ", "][").replace(" ", ",") + "]]";
    }

    public static double trace(Matrix mat) {
        double sum = 0.0;
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            sum += mat.get(i, i);
        }
        return sum;
    }

    public static double[] solveHomogeneousSystem(Matrix A) {
        return MatrixUtils.solveHomogeneousSystem(new DenseMatrix(A.getArray()));
    }

    public static double[] solveHomogeneousSystem(double[][] A) {
        return MatrixUtils.solveHomogeneousSystem(new DenseMatrix(A));
    }

    public static double[] solveHomogeneousSystem(DenseMatrix A) {
        try {
            SVD svd = SVD.factorize(A);
            double[] x = new double[svd.getVt().numRows()];
            int c = svd.getVt().numColumns() - 1;
            for (int i = 0; i < x.length; ++i) {
                x[i] = svd.getVt().get(c, i);
            }
            return x;
        }
        catch (NotConvergedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJavaString(Matrix mat) {
        return "{" + MatrixUtils.toString(mat).trim().replaceAll("^", "{").replace("\n ", "},{").replace(" ", ",") + "}}";
    }

    public static Matrix fromRowPacked(double[] vector, int ncols) {
        int nrows = vector.length / ncols;
        Matrix a = new Matrix(nrows, ncols);
        double[][] ad = a.getArray();
        int i = 0;
        for (int r = 0; r < nrows; ++r) {
            int c = 0;
            while (c < ncols) {
                ad[r][c] = vector[i];
                ++c;
                ++i;
            }
        }
        return a;
    }

    public static Matrix covariance(Matrix m) {
        int N = m.getRowDimension();
        return MatrixUtils.times(m.transpose().times(m), 1.0 / (double)(N > 1 ? N - 1 : N));
    }

    public static Matrix sign(Matrix m) {
        Matrix o = new Matrix(m.getRowDimension(), m.getColumnDimension());
        double[][] md = m.getArray();
        double[][] od = o.getArray();
        for (int r = 0; r < o.getRowDimension(); ++r) {
            for (int c = 0; c < o.getColumnDimension(); ++c) {
                if (md[r][c] > 0.0) {
                    od[r][c] = 1.0;
                }
                if (!(md[r][c] < 0.0)) continue;
                od[r][c] = -1.0;
            }
        }
        return o;
    }

    public static Matrix exp(Matrix m) {
        Matrix o = new Matrix(m.getRowDimension(), m.getColumnDimension());
        double[][] md = m.getArray();
        double[][] od = o.getArray();
        for (int r = 0; r < o.getRowDimension(); ++r) {
            for (int c = 0; c < o.getColumnDimension(); ++c) {
                od[r][c] = Math.exp(md[r][c]);
            }
        }
        return o;
    }

    public static Matrix tanh(Matrix m) {
        Matrix o = new Matrix(m.getRowDimension(), m.getColumnDimension());
        double[][] md = m.getArray();
        double[][] od = o.getArray();
        for (int r = 0; r < o.getRowDimension(); ++r) {
            for (int c = 0; c < o.getColumnDimension(); ++c) {
                od[r][c] = Math.tanh(md[r][c]);
            }
        }
        return o;
    }
}

