/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableMatrix
extends Matrix
implements ReadWriteable {
    private static final long serialVersionUID = 1L;

    protected ReadWriteableMatrix() {
        super(0, 0);
    }

    public ReadWriteableMatrix(double[][] data) {
        super(data);
    }

    public ReadWriteableMatrix(int rows, int cols) {
        super(rows, cols);
    }

    public ReadWriteableMatrix(Matrix data) {
        this(data.getArray());
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        int rows = in.nextInt();
        int cols = in.nextInt();
        double[][] data = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = in.nextDouble();
            }
        }
        this.setData(rows, cols, data);
    }

    @Override
    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int rows = in.readInt();
        int cols = in.readInt();
        double[][] data = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = in.readDouble();
            }
        }
        this.setData(rows, cols, data);
    }

    protected void setData(int m, int n, double[][] data) {
        Class<Matrix> clz = Matrix.class;
        try {
            Field mField = clz.getDeclaredField("m");
            mField.setAccessible(true);
            mField.setInt(this, m);
            Field nField = clz.getDeclaredField("n");
            nField.setAccessible(true);
            nField.setInt(this, n);
            Field AField = clz.getDeclaredField("A");
            AField.setAccessible(true);
            AField.set(this, data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] binaryHeader() {
        return "RWMAT".getBytes();
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        int rows = this.getRowDimension();
        int cols = this.getColumnDimension();
        double[][] data = this.getArray();
        out.print(rows + " " + cols);
        out.println();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                out.print(data[r][c] + " ");
            }
            out.println();
        }
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        int rows = this.getRowDimension();
        int cols = this.getColumnDimension();
        double[][] data = this.getArray();
        out.writeInt(rows);
        out.writeInt(cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                out.writeDouble(data[r][c]);
            }
        }
    }
}

