/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import Jama.Matrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.SingularValues;
import org.openimaj.math.matrix.JamaDenseMatrix;

public class ThinSingularValueDecomposition {
    public Matrix U;
    public double[] S;
    public Matrix Vt;

    public ThinSingularValueDecomposition(Matrix matrix, int ndims) {
        this(new JamaDenseMatrix(matrix), ndims);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThinSingularValueDecomposition(ch.akuhn.matrix.Matrix matrix, int ndims) {
        SingularValues sv = new SingularValues(matrix, ndims);
        Class<ThinSingularValueDecomposition> clazz = ThinSingularValueDecomposition.class;
        synchronized (ThinSingularValueDecomposition.class) {
            sv.decompose();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.S = this.reverse(sv.value);
            this.U = this.vectorArrayToMatrix(sv.vectorLeft, false);
            this.Vt = this.vectorArrayToMatrix(sv.vectorRight, true);
            return;
        }
    }

    protected double[] reverse(double[] vector) {
        for (int i = 0; i < vector.length / 2; ++i) {
            double tmp = vector[i];
            vector[i] = vector[vector.length - i - 1];
            vector[vector.length - i - 1] = tmp;
        }
        return vector;
    }

    protected Matrix vectorArrayToMatrix(Vector[] vectors, boolean rows) {
        int m = vectors.length;
        double[][] data = new double[m][];
        for (int i = 0; i < m; ++i) {
            data[m - i - 1] = vectors[i].unwrap();
        }
        Matrix mat = new Matrix(data);
        if (!rows) {
            mat = mat.transpose();
        }
        return mat;
    }

    public Matrix getSmatrix() {
        Matrix Smat = new Matrix(this.S.length, this.S.length);
        for (int r = 0; r < this.S.length; ++r) {
            Smat.set(r, r, this.S[r]);
        }
        return Smat;
    }

    public Matrix getSmatrixSqrt() {
        Matrix Smat = new Matrix(this.S.length, this.S.length);
        for (int r = 0; r < this.S.length; ++r) {
            Smat.set(r, r, Math.sqrt(this.S[r]));
        }
        return Smat;
    }

    public static Matrix reduceRank(Matrix m, int rank) {
        if (rank > Math.min(m.getColumnDimension(), m.getRowDimension())) {
            return m;
        }
        ThinSingularValueDecomposition t = new ThinSingularValueDecomposition(m, rank);
        return t.U.times(t.getSmatrix()).times(t.Vt);
    }
}

