/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.algorithm.pca;

import Jama.Matrix;
import java.util.Arrays;
import java.util.List;

public abstract class PrincipalComponentAnalysis {
    protected Matrix basis;
    protected double[] mean;
    protected double[] eigenvalues;

    public void learnBasis(List<double[]> data) {
        this.learnBasis((double[][])data.toArray((T[])new double[data.size()][]));
    }

    public void learnBasis(double[][] data) {
        this.learnBasis(new Matrix(data));
    }

    public void learnBasis(Matrix data) {
        Matrix norm = this.buildNormalisedDataMatrix(data);
        this.learnBasisNorm(norm);
    }

    protected abstract void learnBasisNorm(Matrix var1);

    protected Matrix buildNormalisedDataMatrix(Matrix m) {
        double[][] data = m.getArray();
        this.mean = new double[data[0].length];
        for (int j = 0; j < data.length; ++j) {
            for (int i = 0; i < data[0].length; ++i) {
                int n = i;
                this.mean[n] = this.mean[n] + data[j][i];
            }
        }
        int i = 0;
        while (i < data[0].length) {
            int n = i++;
            this.mean[n] = this.mean[n] / (double)data.length;
        }
        Matrix mat = new Matrix(data.length, data[0].length);
        double[][] matdat = mat.getArray();
        for (int j = 0; j < data.length; ++j) {
            for (int i2 = 0; i2 < data[0].length; ++i2) {
                matdat[j][i2] = data[j][i2] - this.mean[i2];
            }
        }
        return mat;
    }

    public Matrix getBasis() {
        return this.basis;
    }

    public double[] getPrincipalComponent(int index) {
        double[] pc = new double[this.basis.getRowDimension()];
        double[][] data = this.basis.getArray();
        for (int r = 0; r < pc.length; ++r) {
            pc[r] = data[r][index];
        }
        return pc;
    }

    public Matrix getEigenVectors() {
        return this.basis;
    }

    public double[] getEigenValues() {
        return this.eigenvalues;
    }

    public double getEigenValue(int i) {
        return this.eigenvalues[i];
    }

    public double getCumulativeEnergy(int i) {
        double energy = 0.0;
        for (int j = 0; j <= i; ++j) {
            energy += this.eigenvalues[i];
        }
        return energy;
    }

    public double[] getCumulativeEnergies() {
        double[] energy = new double[this.eigenvalues.length];
        energy[0] = this.eigenvalues[0];
        for (int j = 1; j < energy.length; ++j) {
            int n = j;
            energy[n] = energy[n] + (energy[j - 1] + this.eigenvalues[j]);
        }
        return energy;
    }

    public double[] getMean() {
        return this.mean;
    }

    public void selectSubset(ComponentSelector selector) {
        selector.select(this);
    }

    public void selectSubset(int n) {
        if (n >= this.eigenvalues.length) {
            return;
        }
        this.basis = this.basis.getMatrix(0, this.basis.getRowDimension() - 1, 0, n - 1);
        this.eigenvalues = Arrays.copyOf(this.eigenvalues, n);
    }

    public void selectSubsetEnergyThreshold(double threshold) {
        double[] energy = this.getCumulativeEnergies();
        for (int i = 1; i < energy.length; ++i) {
            if (!(energy[i] < threshold)) continue;
            this.selectSubset(i - 1);
            return;
        }
    }

    public void selectSubsetPercentageEnergy(double percentage) {
        double[] energy = this.getCumulativeEnergies();
        double total = energy[energy.length - 1];
        for (int i = 1; i < energy.length; ++i) {
            if (!(energy[i] / total > percentage)) continue;
            this.selectSubset(i - 1);
            return;
        }
    }

    public double[] generate(double[] scalings) {
        Matrix scale = new Matrix(this.eigenvalues.length, 1);
        for (int i = 0; i < Math.min(this.eigenvalues.length, scalings.length); ++i) {
            scale.set(i, 0, scalings[i]);
        }
        Matrix meanMatrix = new Matrix(new double[][]{this.mean}).transpose();
        return meanMatrix.plus(this.basis.times(scale)).getColumnPackedCopy();
    }

    public Matrix project(Matrix m) {
        Matrix vec = m.copy();
        int rows = vec.getRowDimension();
        int cols = vec.getColumnDimension();
        double[][] vecarr = vec.getArray();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double[] dArray = vecarr[r];
                int n = c;
                dArray[n] = dArray[n] - this.mean[c];
            }
        }
        return vec.times(this.basis);
    }

    public double[] project(double[] vector) {
        Matrix vec = new Matrix(1, vector.length);
        double[][] vecarr = vec.getArray();
        for (int i = 0; i < vector.length; ++i) {
            vecarr[0][i] = vector[i] - this.mean[i];
        }
        return vec.times(this.basis).getColumnPackedCopy();
    }

    public double[] getStandardDeviations() {
        return this.getStandardDeviations(this.eigenvalues.length);
    }

    public double[] getStandardDeviations(int n) {
        double[] rngs = new double[n];
        for (int i = 0; i < rngs.length; ++i) {
            rngs[i] = Math.sqrt(this.eigenvalues[i]);
        }
        return rngs;
    }

    public String toString() {
        return String.format("PrincipalComponentAnalysis[dims=%d]", this.eigenvalues == null ? 0 : this.eigenvalues.length);
    }

    public static class PercentageEnergyComponentSelector
    implements ComponentSelector {
        double percentage;

        public PercentageEnergyComponentSelector(double percentage) {
            this.percentage = percentage;
        }

        @Override
        public void select(PrincipalComponentAnalysis pca) {
            pca.selectSubsetPercentageEnergy(this.percentage);
        }
    }

    public static class EnergyThresholdComponentSelector
    implements ComponentSelector {
        double threshold;

        public EnergyThresholdComponentSelector(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public void select(PrincipalComponentAnalysis pca) {
            pca.selectSubsetEnergyThreshold(this.threshold);
        }
    }

    public static class NumberComponentSelector
    implements ComponentSelector {
        int n;

        public NumberComponentSelector(int n) {
            this.n = n;
        }

        @Override
        public void select(PrincipalComponentAnalysis pca) {
            pca.selectSubset(this.n);
        }
    }

    public static interface ComponentSelector {
        public void select(PrincipalComponentAnalysis var1);
    }
}

