/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.algorithm.pca;

import Jama.Matrix;
import java.util.Arrays;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.EconomySVD;
import no.uib.cipr.matrix.NotConvergedException;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;

public class SvdPrincipalComponentAnalysis
extends PrincipalComponentAnalysis {
    int ndims;

    public SvdPrincipalComponentAnalysis() {
        this(-1);
    }

    public SvdPrincipalComponentAnalysis(int ndims) {
        this.ndims = ndims;
    }

    @Override
    public void learnBasisNorm(Matrix norm) {
        try {
            DenseMatrix mjtA = new DenseMatrix(norm.getArray());
            EconomySVD svd = EconomySVD.factorize(mjtA);
            DenseMatrix output = svd.getVt();
            int dims = this.ndims < 0 ? svd.getS().length : this.ndims;
            this.basis = new Matrix(output.numColumns(), dims);
            this.eigenvalues = Arrays.copyOf(svd.getS(), dims);
            double normEig = 1.0 / (double)(norm.getRowDimension() - 1);
            for (int i = 0; i < this.eigenvalues.length; ++i) {
                this.eigenvalues[i] = this.eigenvalues[i] * this.eigenvalues[i] * normEig;
            }
            double[][] basisData = this.basis.getArray();
            for (int j = 0; j < output.numColumns(); ++j) {
                for (int i = 0; i < dims; ++i) {
                    basisData[j][i] = output.get(i, j);
                }
            }
        }
        catch (NotConvergedException e) {
            throw new RuntimeException(e);
        }
    }
}

