/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.similarity.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.matrix.similarity.SimilarityMatrix;
import org.openimaj.math.matrix.similarity.processor.NormaliseData;
import org.openimaj.math.matrix.similarity.processor.SimilarityMatrixProcessor;
import org.openimaj.util.pair.IndependentPair;

public class MultidimensionalScaling
implements SimilarityMatrixProcessor {
    protected Random rng = new Random();
    protected int numIterations = 1000;
    protected double rate = 0.01;
    protected List<IndependentPair<String, Point2d>> points;

    public MultidimensionalScaling() {
    }

    public MultidimensionalScaling(Random rng) {
        this.rng = rng;
    }

    public MultidimensionalScaling(int numIterations, double rate) {
        this.numIterations = numIterations;
        this.rate = rate;
    }

    public MultidimensionalScaling(int numIterations, double rate, Random rng) {
        this.numIterations = numIterations;
        this.rate = rate;
        this.rng = rng;
    }

    @Override
    public void process(SimilarityMatrix matrix) {
        int sz = matrix.getRowDimension();
        double[][] realDists = matrix.process(new NormaliseData(true)).getArray();
        this.points = new ArrayList<IndependentPair<String, Point2d>>(sz);
        for (int i = 0; i < sz; ++i) {
            this.points.add(new IndependentPair<String, Point2d>(matrix.getIndexValue(i), Point2dImpl.createRandomPoint()));
        }
        Point2dImpl[] grad = new Point2dImpl[sz];
        for (int i = 0; i < sz; ++i) {
            grad[i] = new Point2dImpl();
        }
        double lastError = Double.MAX_VALUE;
        double[][] fakeDists = new double[sz][sz];
        for (int m = 0; m < this.numIterations; ++m) {
            int k;
            for (int r = 0; r < sz; ++r) {
                for (int c = r + 1; c < sz; ++c) {
                    double dist;
                    fakeDists[r][c] = dist = Line2d.distance(this.points.get(r).secondObject(), this.points.get(c).secondObject());
                    fakeDists[c][r] = dist;
                }
            }
            for (int i = 0; i < sz; ++i) {
                grad[i].x = 0.0f;
                grad[i].y = 0.0f;
            }
            double totalError = 0.0;
            for (k = 0; k < sz; ++k) {
                for (int j = 0; j < sz; ++j) {
                    if (k == j) continue;
                    double errorterm = (fakeDists[j][k] - realDists[j][k]) / realDists[j][k];
                    grad[k].x = (float)((double)grad[k].x + (double)(((Point2dImpl)this.points.get((int)k).secondObject()).x - this.points.get(j).secondObject().getX()) / fakeDists[j][k] * errorterm);
                    grad[k].y = (float)((double)grad[k].y + (double)(((Point2dImpl)this.points.get((int)k).secondObject()).y - this.points.get(j).secondObject().getY()) / fakeDists[j][k] * errorterm);
                    totalError += Math.abs(errorterm);
                }
            }
            if (lastError < totalError) break;
            lastError = totalError;
            for (k = 0; k < sz; ++k) {
                ((Point2dImpl)this.points.get((int)k).secondObject()).x = (float)((double)((Point2dImpl)this.points.get((int)k).secondObject()).x - this.rate * (double)grad[k].x);
                ((Point2dImpl)this.points.get((int)k).secondObject()).y = (float)((double)((Point2dImpl)this.points.get((int)k).secondObject()).y - this.rate * (double)grad[k].y);
            }
        }
    }

    public List<IndependentPair<String, Point2d>> getPoints() {
        return this.points;
    }

    public Point2d getPoint(String key) {
        for (IndependentPair<String, Point2d> pair : this.points) {
            if (!pair.firstObject().equals(key)) continue;
            return pair.secondObject();
        }
        return null;
    }

    public String toString() {
        if (this.points == null) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (IndependentPair<String, Point2d> pair : this.points) {
            sb.append(String.format("%s\t%4.3f\t%4.3f\n", pair.firstObject(), Float.valueOf(pair.secondObject().getX()), Float.valueOf(pair.secondObject().getY())));
        }
        return sb.toString();
    }
}

