/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model;

import gov.sandia.cognition.learning.algorithm.bayes.VectorNaiveBayesCategorizer;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.pair.IndependentPair;

public class GaussianVectorNaiveBayesModel<T>
implements EstimatableModel<double[], T> {
    VectorNaiveBayesCategorizer.BatchGaussianLearner<T> learner = new VectorNaiveBayesCategorizer.BatchGaussianLearner();
    private VectorNaiveBayesCategorizer<T, UnivariateGaussian.PDF> model;

    @Override
    public boolean estimate(List<? extends IndependentPair<double[], T>> data) {
        ArrayList<DefaultInputOutputPair<Vector, T>> cfdata = new ArrayList<DefaultInputOutputPair<Vector, T>>();
        for (IndependentPair<double[], T> d : data) {
            DefaultInputOutputPair<Vector, T> iop = new DefaultInputOutputPair<Vector, T>(VectorFactory.getDefault().copyArray(d.firstObject()), d.secondObject());
            cfdata.add(iop);
        }
        this.model = this.learner.learn((Collection<InputOutputPair<Vectorizable, T>>)cfdata);
        return true;
    }

    @Override
    public T predict(double[] data) {
        return this.model.evaluate(VectorFactory.getDefault().copyArray(data));
    }

    @Override
    public int numItemsToEstimate() {
        return 0;
    }

    public GaussianVectorNaiveBayesModel<T> clone() {
        try {
            return (GaussianVectorNaiveBayesModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        GaussianVectorNaiveBayesModel model = new GaussianVectorNaiveBayesModel();
        ArrayList<IndependentPair<double[], Boolean>> data = new ArrayList<IndependentPair<double[], Boolean>>();
        data.add(IndependentPair.pair(new double[]{0.0}, true));
        data.add(IndependentPair.pair(new double[]{0.1}, true));
        data.add(IndependentPair.pair(new double[]{-0.1}, true));
        data.add(IndependentPair.pair(new double[]{9.9}, false));
        data.add(IndependentPair.pair(new double[]{10.0}, false));
        data.add(IndependentPair.pair(new double[]{10.1}, false));
        model.estimate((List)data);
        double[] q = new double[]{5.0};
        System.out.println(model.predict(q));
        System.out.println(" logP(true): " + model.model.computeLogPosterior(VectorFactory.getDefault().copyArray(q), true));
        System.out.println("logP(false): " + model.model.computeLogPosterior(VectorFactory.getDefault().copyArray(q), false));
        System.out.println("    P(true): " + model.model.computePosterior(VectorFactory.getDefault().copyArray(q), true));
        System.out.println("   P(false): " + model.model.computePosterior(VectorFactory.getDefault().copyArray(q), false));
        System.out.println(model.model.getPriors());
    }
}

