/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model;

import java.util.List;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.pair.IndependentPair;

public class LeastSquaresLinearModel
implements EstimatableModel<Integer, Integer> {
    private double c;
    private double m;
    private int nEstimates = 10;

    public LeastSquaresLinearModel() {
        this.nEstimates = 2;
    }

    public LeastSquaresLinearModel(int nEstimates) {
        if (nEstimates < 2) {
            nEstimates = 2;
        } else {
            this.nEstimates = nEstimates;
        }
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Integer, Integer>> data) {
        double sumXi = 0.0;
        double sumYi = 0.0;
        double sumXiXi = 0.0;
        double sumXiYi = 0.0;
        int n = 0;
        for (IndependentPair<Integer, Integer> independentPair : data) {
            int xi = independentPair.firstObject();
            int yi = independentPair.secondObject();
            sumXi += (double)xi;
            sumYi += (double)yi;
            sumXiXi += (double)(xi * xi);
            sumXiYi += (double)(xi * yi);
            ++n;
        }
        this.c = (sumYi * sumXiXi - sumXi * sumXiYi) / ((double)n * sumXiXi - sumXi * sumXi);
        this.m = ((double)n * sumXiYi - sumXi * sumYi) / ((double)n * sumXiXi - sumXi * sumXi);
        return true;
    }

    @Override
    public Integer predict(Integer data) {
        return (int)Math.round(this.m * (double)data.intValue() + this.c);
    }

    @Override
    public int numItemsToEstimate() {
        return this.nEstimates;
    }

    public LeastSquaresLinearModel clone() {
        LeastSquaresLinearModel model = new LeastSquaresLinearModel(this.nEstimates);
        model.c = this.c;
        model.m = this.m;
        return model;
    }

    public String toString() {
        return "Least Squares Fit: (m,c) = (" + this.m + "," + this.c + ")";
    }

    public double getM() {
        return this.m;
    }

    public double getC() {
        return this.c;
    }
}

