/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model.fit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.math.util.DoubleArrayStatsUtils;
import org.openimaj.util.CollectionSampler;
import org.openimaj.util.UniformSampler;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Article, author={"Peter J. Rousseeuw"}, title="Least Median of Squares Regression", year="1984", journal="Journal of the American Statistical Association", pages={"871", "", "880"}, url="http://www.jstor.org/stable/2288718", month="December", number="388", volume="79")
public class LMedS<I, D, M extends EstimatableModel<I, D>>
implements RobustModelFitting<I, D, M> {
    double probability = 0.99;
    double inlierNoiseLevel = -1.0;
    double outlierProportion = 0.4;
    private double degreesOfFreedom;
    protected ResidualCalculator<I, D, M> residualEstimator;
    protected boolean improveEstimate;
    protected M model;
    protected M bestModel;
    protected List<IndependentPair<I, D>> inliers = new ArrayList<IndependentPair<I, D>>();
    protected List<IndependentPair<I, D>> outliers = new ArrayList<IndependentPair<I, D>>();
    protected CollectionSampler<IndependentPair<I, D>> sampler;
    private double bestMedianError;

    public LMedS(M model, ResidualCalculator<I, D, M> residualEstimator, boolean impEst) {
        this(model, residualEstimator, impEst, new UniformSampler<IndependentPair<I, D>>());
    }

    public LMedS(M model, ResidualCalculator<I, D, M> residualEstimator, double outlierProportion, boolean impEst) {
        this(model, residualEstimator, impEst);
        this.outlierProportion = outlierProportion;
    }

    public LMedS(M model, ResidualCalculator<I, D, M> residualEstimator, double outlierProportion, double inlierNoiseLevel, double degreesOfFreedom, boolean impEst) {
        this(model, residualEstimator, outlierProportion, impEst);
        this.inlierNoiseLevel = inlierNoiseLevel;
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public LMedS(M model, ResidualCalculator<I, D, M> residualEstimator, boolean impEst, CollectionSampler<IndependentPair<I, D>> sampler) {
        this.model = model;
        this.residualEstimator = residualEstimator;
        this.bestModel = model.clone();
        this.improveEstimate = impEst;
        this.sampler = sampler;
    }

    public LMedS(M model, ResidualCalculator<I, D, M> residualEstimator, double outlierProportion, boolean impEst, CollectionSampler<IndependentPair<I, D>> sampler) {
        this(model, residualEstimator, impEst, sampler);
        this.outlierProportion = outlierProportion;
    }

    public LMedS(M model, ResidualCalculator<I, D, M> residualEstimator, double outlierProportion, double inlierNoiseLevel, double degreesOfFreedom, boolean impEst, CollectionSampler<IndependentPair<I, D>> sampler) {
        this(model, residualEstimator, outlierProportion, impEst, sampler);
        this.inlierNoiseLevel = inlierNoiseLevel;
        this.degreesOfFreedom = degreesOfFreedom;
    }

    @Override
    public boolean fitData(List<? extends IndependentPair<I, D>> data) {
        int sampleSize = this.model.numItemsToEstimate();
        if (data.size() < sampleSize) {
            return false;
        }
        int numSamples = (int)Math.ceil(Math.log(1.0 - this.probability) / Math.log(1.0 - Math.pow(1.0 - this.outlierProportion, sampleSize)));
        double[] errors = new double[data.size()];
        double[] bestErrors = new double[data.size()];
        Arrays.fill(bestErrors, Double.MAX_VALUE);
        this.bestMedianError = Double.MAX_VALUE;
        this.sampler.setCollection(data);
        for (int i = 0; i < numSamples; ++i) {
            List<IndependentPair<I, D>> sample = this.sampler.sample(sampleSize);
            if (!this.model.estimate(sample)) continue;
            this.residualEstimator.setModel(this.model);
            this.residualEstimator.computeResiduals(data, errors);
            double medianError = DoubleArrayStatsUtils.median(errors);
            if (!(medianError < this.bestMedianError)) continue;
            this.bestMedianError = medianError;
            M tmp = this.bestModel;
            this.bestModel = this.model;
            this.model = tmp;
            double[] tmp2 = bestErrors;
            bestErrors = errors;
            errors = tmp2;
        }
        this.findInliersOutliers(data, bestErrors);
        if (this.improveEstimate && !this.bestModel.estimate(this.inliers)) {
            return false;
        }
        double outlierProp = (double)this.outliers.size() / (double)data.size();
        return outlierProp < this.outlierProportion;
    }

    private void findInliersOutliers(List<? extends IndependentPair<I, D>> data, double[] bestErrors) {
        double threshold;
        this.inliers.clear();
        this.outliers.clear();
        if (this.inlierNoiseLevel > 0.0) {
            threshold = this.inlierNoiseLevel * this.inlierNoiseLevel * new ChiSquaredDistribution(this.degreesOfFreedom).inverseCumulativeProbability(this.probability);
        } else {
            double sigmahat = 1.4826 * (double)(1 + 5 / Math.max(1, data.size() - this.model.numItemsToEstimate())) * Math.sqrt(this.bestMedianError);
            threshold = 2.5 * sigmahat * (2.5 * sigmahat);
        }
        for (int i = 0; i < data.size(); ++i) {
            if (bestErrors[i] < threshold) {
                this.inliers.add(data.get(i));
                continue;
            }
            this.outliers.add(data.get(i));
        }
    }

    @Override
    public M getModel() {
        return this.bestModel;
    }

    @Override
    public List<? extends IndependentPair<I, D>> getInliers() {
        return this.inliers;
    }

    @Override
    public List<? extends IndependentPair<I, D>> getOutliers() {
        return this.outliers;
    }

    @Override
    public int numItemsToEstimate() {
        return this.model.numItemsToEstimate();
    }
}

