/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model.fit;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.math.util.distance.DistanceCheck;
import org.openimaj.math.util.distance.ThresholdDistanceCheck;
import org.openimaj.util.CollectionSampler;
import org.openimaj.util.UniformSampler;
import org.openimaj.util.pair.IndependentPair;

public class RANSAC<I, D, M extends EstimatableModel<I, D>>
implements RobustModelFitting<I, D, M> {
    protected M model;
    protected ResidualCalculator<I, D, M> errorModel;
    protected DistanceCheck dc;
    protected int nIter;
    protected boolean improveEstimate;
    protected List<IndependentPair<I, D>> inliers;
    protected List<IndependentPair<I, D>> outliers;
    protected List<IndependentPair<I, D>> bestModelInliers;
    protected List<IndependentPair<I, D>> bestModelOutliers;
    protected StoppingCondition stoppingCondition;
    protected List<? extends IndependentPair<I, D>> modelConstructionData;
    protected CollectionSampler<IndependentPair<I, D>> sampler;

    public RANSAC(M model, ResidualCalculator<I, D, M> errorModel, double errorThreshold, int nIterations, StoppingCondition stoppingCondition, boolean impEst) {
        this(model, errorModel, new ThresholdDistanceCheck(errorThreshold), nIterations, stoppingCondition, impEst);
    }

    public RANSAC(M model, ResidualCalculator<I, D, M> errorModel, DistanceCheck dc, int nIterations, StoppingCondition stoppingCondition, boolean impEst) {
        this(model, errorModel, dc, nIterations, stoppingCondition, impEst, new UniformSampler<IndependentPair<I, D>>());
    }

    public RANSAC(M model, ResidualCalculator<I, D, M> errorModel, double errorThreshold, int nIterations, StoppingCondition stoppingCondition, boolean impEst, CollectionSampler<IndependentPair<I, D>> sampler) {
        this(model, errorModel, new ThresholdDistanceCheck(errorThreshold), nIterations, stoppingCondition, impEst, sampler);
    }

    public RANSAC(M model, ResidualCalculator<I, D, M> errorModel, DistanceCheck dc, int nIterations, StoppingCondition stoppingCondition, boolean impEst, CollectionSampler<IndependentPair<I, D>> sampler) {
        this.stoppingCondition = stoppingCondition;
        this.model = model;
        this.errorModel = errorModel;
        this.dc = dc;
        this.nIter = nIterations;
        this.improveEstimate = impEst;
        this.inliers = new ArrayList<IndependentPair<I, D>>();
        this.outliers = new ArrayList<IndependentPair<I, D>>();
        this.sampler = sampler;
    }

    @Override
    public boolean fitData(List<? extends IndependentPair<I, D>> data) {
        int M = this.model.numItemsToEstimate();
        this.bestModelInliers = null;
        this.bestModelOutliers = null;
        if (data.size() < M || !this.stoppingCondition.init(data, (EstimatableModel<?, ?>)this.model)) {
            return false;
        }
        this.sampler.setCollection(data);
        for (int l = 0; l < this.nIter; ++l) {
            List<IndependentPair<I, D>> rnd = this.sampler.sample(M);
            this.setModelConstructionData(rnd);
            if (!this.model.estimate(rnd)) continue;
            this.errorModel.setModel(this.model);
            int K = 0;
            this.inliers.clear();
            this.outliers.clear();
            for (IndependentPair<I, D> dp : data) {
                if (this.dc.check(this.errorModel.computeResidual(dp))) {
                    ++K;
                    this.inliers.add(dp);
                    continue;
                }
                this.outliers.add(dp);
            }
            if (this.bestModelInliers == null || this.inliers.size() >= this.bestModelInliers.size()) {
                this.bestModelInliers = new ArrayList<IndependentPair<I, D>>(this.inliers);
                this.bestModelOutliers = new ArrayList<IndependentPair<I, D>>(this.outliers);
            }
            if (!this.stoppingCondition.shouldStopIterations(K)) continue;
            this.inliers = this.bestModelInliers;
            this.outliers = this.bestModelOutliers;
            if (this.improveEstimate && this.inliers.size() >= this.model.numItemsToEstimate() && !this.model.estimate(this.inliers)) {
                return false;
            }
            boolean stopping = this.stoppingCondition.finalFitCondition(this.inliers.size());
            return stopping;
        }
        if (this.bestModelInliers == null) {
            this.bestModelInliers = new ArrayList<IndependentPair<I, D>>();
            this.bestModelOutliers = new ArrayList<IndependentPair<I, D>>();
        }
        this.inliers = this.bestModelInliers;
        this.outliers = this.bestModelOutliers;
        if (this.bestModelInliers.size() >= M && !this.model.estimate(this.bestModelInliers)) {
            return false;
        }
        return this.stoppingCondition.finalFitCondition(this.inliers.size());
    }

    @Override
    public List<? extends IndependentPair<I, D>> getInliers() {
        return this.inliers;
    }

    @Override
    public List<? extends IndependentPair<I, D>> getOutliers() {
        return this.outliers;
    }

    public int getMaxIterations() {
        return this.nIter;
    }

    public void setMaxIterations(int nIter) {
        this.nIter = nIter;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    public void setModel(M model) {
        this.model = model;
    }

    public boolean isImproveEstimate() {
        return this.improveEstimate;
    }

    public void setImproveEstimate(boolean improveEstimate) {
        this.improveEstimate = improveEstimate;
    }

    public void setModelConstructionData(List<? extends IndependentPair<I, D>> modelConstructionData) {
        this.modelConstructionData = modelConstructionData;
    }

    public List<? extends IndependentPair<I, D>> getModelConstructionData() {
        return this.modelConstructionData;
    }

    @Override
    public int numItemsToEstimate() {
        return this.model.numItemsToEstimate();
    }

    public static class BestFitStoppingCondition
    implements StoppingCondition {
        int required;

        @Override
        public boolean init(List<?> data, EstimatableModel<?, ?> model) {
            this.required = model.numItemsToEstimate();
            return true;
        }

        @Override
        public boolean shouldStopIterations(int numInliers) {
            return false;
        }

        @Override
        public boolean finalFitCondition(int numInliers) {
            return numInliers > this.required;
        }
    }

    public static class ProbabilisticMinInliersStoppingCondition
    implements StoppingCondition {
        private static final double DEFAULT_INLIER_IS_BAD_PROBABILITY = 0.1;
        private static final double DEFAULT_PERCENTAGE_INLIERS = 0.25;
        private double inlierIsBadProbability;
        private double desiredErrorProbability;
        private double percentageInliers;
        private int numItemsToEstimate;
        private int iteration = 0;
        private int limit;
        private int maxInliers = 0;
        private double currentProb;
        private int numDataItems;

        public ProbabilisticMinInliersStoppingCondition(double desiredErrorProbability, double inlierIsBadProbability, double percentageInliers) {
            this.desiredErrorProbability = desiredErrorProbability;
            this.inlierIsBadProbability = inlierIsBadProbability;
            this.percentageInliers = percentageInliers;
        }

        public ProbabilisticMinInliersStoppingCondition(double desiredErrorProbability) {
            this(desiredErrorProbability, 0.1, 0.25);
        }

        @Override
        public boolean init(List<?> data, EstimatableModel<?, ?> model) {
            this.numItemsToEstimate = model.numItemsToEstimate();
            this.numDataItems = data.size();
            this.limit = this.calculateMinInliers();
            this.iteration = 0;
            this.currentProb = 1.0;
            this.maxInliers = 0;
            return true;
        }

        @Override
        public boolean finalFitCondition(int numInliers) {
            return numInliers >= this.limit;
        }

        private int calculateMinInliers() {
            int j;
            for (j = this.numItemsToEstimate + 1; j <= this.numDataItems; ++j) {
                double sum = 0.0;
                for (int i = j; i <= this.numDataItems; ++i) {
                    double pi = (double)(i - this.numItemsToEstimate) * Math.log(this.inlierIsBadProbability) + (double)(this.numDataItems - i + this.numItemsToEstimate) * Math.log(1.0 - this.inlierIsBadProbability) + this.log_factorial(this.numDataItems - this.numItemsToEstimate) - this.log_factorial(i - this.numItemsToEstimate) - this.log_factorial(this.numDataItems - i);
                    sum += Math.exp(pi);
                }
                if (sum < this.desiredErrorProbability) break;
            }
            return j;
        }

        private double log_factorial(int n) {
            double f = 0.0;
            for (int i = 1; i <= n; ++i) {
                f += Math.log(i);
            }
            return f;
        }

        @Override
        public boolean shouldStopIterations(int numInliers) {
            if (numInliers > this.maxInliers) {
                this.maxInliers = numInliers;
                this.percentageInliers = (double)this.maxInliers / (double)this.numDataItems;
            }
            this.currentProb = Math.pow(1.0 - Math.pow(this.percentageInliers, this.numItemsToEstimate), ++this.iteration);
            return this.currentProb <= this.desiredErrorProbability;
        }
    }

    public static class PercentageInliersStoppingCondition
    extends NumberInliersStoppingCondition {
        double percentageLimit;

        public PercentageInliersStoppingCondition(double percentageLimit) {
            super(0);
            this.percentageLimit = percentageLimit;
        }

        @Override
        public boolean init(List<?> data, EstimatableModel<?, ?> model) {
            this.limit = (int)Math.rint(this.percentageLimit * (double)data.size());
            return super.init(data, model);
        }
    }

    public static class NumberInliersStoppingCondition
    implements StoppingCondition {
        int limit;

        public NumberInliersStoppingCondition(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean init(List<?> data, EstimatableModel<?, ?> model) {
            if (this.limit < model.numItemsToEstimate()) {
                this.limit = model.numItemsToEstimate();
            }
            return data.size() >= this.limit;
        }

        @Override
        public boolean shouldStopIterations(int numInliers) {
            return numInliers >= this.limit;
        }

        @Override
        public boolean finalFitCondition(int numInliers) {
            return numInliers >= this.limit;
        }
    }

    public static interface StoppingCondition {
        public boolean init(List<?> var1, EstimatableModel<?, ?> var2);

        public boolean shouldStopIterations(int var1);

        public boolean finalFitCondition(int var1);
    }
}

