/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.normalisation;

import org.openimaj.math.statistics.normalisation.Normaliser;
import org.openimaj.math.util.DoubleArrayStatsUtils;
import org.openimaj.util.array.ArrayUtils;

public class PerExampleMeanCenterVar
implements Normaliser {
    double eps = 0.0392156862745098;

    public PerExampleMeanCenterVar(double eps) {
        this.eps = eps;
    }

    @Override
    public double[] normalise(double[] vector) {
        double mean = DoubleArrayStatsUtils.mean(vector);
        double var = DoubleArrayStatsUtils.var(vector);
        vector = ArrayUtils.subtract(vector, mean);
        vector = ArrayUtils.divide(vector, Math.sqrt(var + this.eps));
        return vector;
    }

    @Override
    public double[][] normalise(double[][] data) {
        double[][] out = new double[data.length][];
        for (int c = 0; c < out.length; ++c) {
            out[c] = this.normalise(data[c]);
        }
        return out;
    }
}

