/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.util;

import org.openimaj.util.array.ArrayUtils;

public class DoubleArrayStatsUtils {
    public static double mean(double[] arr) {
        if (arr.length == 0) {
            return 0.0;
        }
        int count = 1;
        double mean = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            mean += (arr[i] - mean) / (double)(++count);
        }
        return mean;
    }

    public static double mean(double[][] arr) {
        if (arr.length == 0) {
            return 0.0;
        }
        int firstRowIndex = 0;
        while (arr[firstRowIndex].length == 0) {
            ++firstRowIndex;
        }
        int firstColIndex = 1;
        int count = 1;
        double mean = arr[firstRowIndex][0];
        for (int i = firstRowIndex; i < arr.length; ++i) {
            for (int j = firstColIndex; j < arr[i].length; ++j) {
                mean += (arr[i][j] - mean) / (double)(++count);
            }
            firstColIndex = 0;
        }
        return mean;
    }

    public static double var(double[] arr) {
        if (arr.length < 2) {
            return 0.0;
        }
        int count = 1;
        double oldMean = arr[0];
        double newMean = arr[0];
        double var = 0.0;
        for (int i = 1; i < arr.length; ++i) {
            double x = arr[i];
            newMean = oldMean + (x - oldMean) / (double)(++count);
            var += (x - oldMean) * (x - newMean);
            oldMean = newMean;
        }
        return var / (double)(count - 1);
    }

    public static double var(double[][] arr) {
        if (arr.length == 0) {
            return 0.0;
        }
        int firstRowIndex = 0;
        while (arr[firstRowIndex].length == 0) {
            ++firstRowIndex;
        }
        int firstColIndex = 1;
        int count = 1;
        double oldMean = arr[firstRowIndex][0];
        double newMean = arr[firstRowIndex][0];
        double var = 0.0;
        for (int i = firstRowIndex; i < arr.length; ++i) {
            for (int j = firstColIndex; j < arr[i].length; ++j) {
                double x = arr[i][j];
                newMean = oldMean + (x - oldMean) / (double)(++count);
                var += (x - oldMean) * (x - newMean);
                oldMean = newMean;
            }
            firstColIndex = 0;
        }
        return count > 1 ? var / (double)(count - 1) : 0.0;
    }

    public static double std(double[][] arr) {
        return Math.sqrt(DoubleArrayStatsUtils.var(arr));
    }

    public static double std(double[] arr) {
        return Math.sqrt(DoubleArrayStatsUtils.var(arr));
    }

    public static double sum(double[][] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += DoubleArrayStatsUtils.sum(arr[i]);
        }
        return sum;
    }

    public static double sum(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum;
    }

    public static double sumSq(double[][] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += DoubleArrayStatsUtils.sumSq(arr[i]);
        }
        return sum;
    }

    public static double sumSq(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i] * arr[i];
        }
        return sum;
    }

    public static double sumAbs(double[][] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += DoubleArrayStatsUtils.sumAbs(arr[i]);
        }
        return sum;
    }

    public static double sumAbs(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += Math.abs(arr[i]);
        }
        return sum;
    }

    public static double median(double[] arr) {
        int median = arr.length / 2;
        if (arr.length % 2 == 0) {
            double a = ArrayUtils.quickSelect(arr, median);
            double b = ArrayUtils.quickSelect(arr, median - 1);
            return (a + b) / 2.0;
        }
        return ArrayUtils.quickSelect(arr, median);
    }

    public static double median(double[] arr, int start, int stop) {
        int median = arr.length / 2;
        if (arr.length % 2 == 0) {
            double a = ArrayUtils.quickSelect(arr, median, start, stop);
            double b = ArrayUtils.quickSelect(arr, median - 1, start, stop);
            return (a + b) / 2.0;
        }
        return ArrayUtils.quickSelect(arr, median, start, stop);
    }
}

