/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.util;

import org.openimaj.util.array.ArrayUtils;

public class FloatArrayStatsUtils {
    public static float mean(float[] arr) {
        if (arr.length == 0) {
            return 0.0f;
        }
        int count = 1;
        float mean = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            mean += (arr[i] - mean) / (float)(++count);
        }
        return mean;
    }

    public static float mean(float[][] arr) {
        if (arr.length == 0) {
            return 0.0f;
        }
        int firstRowIndex = 0;
        while (arr[firstRowIndex].length == 0) {
            ++firstRowIndex;
        }
        int firstColIndex = 1;
        int count = 1;
        float mean = arr[firstRowIndex][0];
        for (int i = firstRowIndex; i < arr.length; ++i) {
            for (int j = firstColIndex; j < arr[i].length; ++j) {
                mean += (arr[i][j] - mean) / (float)(++count);
            }
            firstColIndex = 0;
        }
        return mean;
    }

    public static float var(float[] arr) {
        if (arr.length < 2) {
            return 0.0f;
        }
        int count = 1;
        float oldMean = arr[0];
        float newMean = arr[0];
        float var = 0.0f;
        for (int i = 1; i < arr.length; ++i) {
            float x = arr[i];
            newMean = oldMean + (x - oldMean) / (float)(++count);
            var += (x - oldMean) * (x - newMean);
            oldMean = newMean;
        }
        return var / (float)(count - 1);
    }

    public static float var(float[][] arr) {
        if (arr.length == 0) {
            return 0.0f;
        }
        int firstRowIndex = 0;
        while (arr[firstRowIndex].length == 0) {
            ++firstRowIndex;
        }
        int firstColIndex = 1;
        int count = 1;
        float oldMean = arr[firstRowIndex][0];
        float newMean = arr[firstRowIndex][0];
        float var = 0.0f;
        for (int i = firstRowIndex; i < arr.length; ++i) {
            for (int j = firstColIndex; j < arr[i].length; ++j) {
                float x = arr[i][j];
                newMean = oldMean + (x - oldMean) / (float)(++count);
                var += (x - oldMean) * (x - newMean);
                oldMean = newMean;
            }
            firstColIndex = 0;
        }
        return count > 1 ? var / (float)(count - 1) : 0.0f;
    }

    public static float std(float[][] arr) {
        return (float)Math.sqrt(FloatArrayStatsUtils.var(arr));
    }

    public static float std(float[] arr) {
        return (float)Math.sqrt(FloatArrayStatsUtils.var(arr));
    }

    public static float sum(float[][] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += FloatArrayStatsUtils.sum(arr[i]);
        }
        return sum;
    }

    public static float sum(float[] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum;
    }

    public static float sumSq(float[][] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += FloatArrayStatsUtils.sumSq(arr[i]);
        }
        return sum;
    }

    public static float sumSq(float[] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i] * arr[i];
        }
        return sum;
    }

    public static float sumAbs(float[][] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += FloatArrayStatsUtils.sumAbs(arr[i]);
        }
        return sum;
    }

    public static float sumAbs(float[] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += Math.abs(arr[i]);
        }
        return sum;
    }

    public static float median(float[] arr) {
        int median = arr.length / 2;
        if (arr.length % 2 == 0) {
            float a = ArrayUtils.quickSelect(arr, median);
            float b = ArrayUtils.quickSelect(arr, median - 1);
            return (a + b) / 2.0f;
        }
        return ArrayUtils.quickSelect(arr, median);
    }

    public static float median(float[] arr, int start, int stop) {
        int median = arr.length / 2;
        if (arr.length % 2 == 0) {
            float a = ArrayUtils.quickSelect(arr, median, start, stop);
            float b = ArrayUtils.quickSelect(arr, median - 1, start, stop);
            return (a + b) / 2.0f;
        }
        return ArrayUtils.quickSelect(arr, median, start, stop);
    }
}

