/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntByteIterator;
import gnu.trove.map.hash.TIntByteHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseByteArray;

public class SparseHashedByteArray
extends SparseByteArray {
    TIntByteHashMap data;

    public SparseHashedByteArray(byte[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseHashedByteArray(int length) {
        this(length, 10);
    }

    public SparseHashedByteArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.data = new TIntByteHashMap(capacity);
    }

    public SparseHashedByteArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.data = new TIntByteHashMap(capacity);
    }

    @Override
    public byte increment(int key, byte value) {
        return this.data.adjustOrPutValue(key, value, value);
    }

    @Override
    public int[] indices() {
        return this.data.keys();
    }

    @Override
    public byte[] values() {
        return this.data.values();
    }

    @Override
    public Iterable<SparseByteArray.Entry> entries() {
        return new Iterable<SparseByteArray.Entry>(){

            @Override
            public Iterator<SparseByteArray.Entry> iterator() {
                return new Iterator<SparseByteArray.Entry>(){
                    private SparseByteArray.Entry entry = new SparseByteArray.Entry();
                    private TIntByteIterator iterator;
                    {
                        this.iterator = SparseHashedByteArray.this.data.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public SparseByteArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.iterator.advance();
                        this.entry.index = this.iterator.key();
                        this.entry.value = this.iterator.value();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseHashedByteArray)) {
            return false;
        }
        return this.length == ((SparseHashedByteArray)obj).length && this.data.equals(((SparseHashedByteArray)obj).data);
    }

    @Override
    public byte get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.length ^ this.data.hashCode();
    }

    @Override
    public boolean isUsed(int key) {
        return this.data.contains(key);
    }

    @Override
    public byte set(int key, byte value) {
        return this.data.put(key, value);
    }

    @Override
    public int used() {
        return this.data.size();
    }

    @Override
    public void compact() {
        this.data.compact();
    }

    @Override
    public SparseByteArray copy() {
        SparseHashedByteArray copy = new SparseHashedByteArray(this.length);
        copy.data = new TIntByteHashMap(this.data);
        return copy;
    }

    @Override
    public SparseByteArray reverse() {
        TIntByteHashMap tmp = new TIntByteHashMap(this.data.size());
        for (SparseByteArray.Entry e : this.entries()) {
            tmp.put(this.length - e.index, e.value);
        }
        this.data = tmp;
        return this;
    }
}

