/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseDoubleArray;

public class SparseHashedDoubleArray
extends SparseDoubleArray {
    TIntDoubleHashMap data;

    public SparseHashedDoubleArray(double[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseHashedDoubleArray(int length) {
        this(length, 10);
    }

    public SparseHashedDoubleArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.data = new TIntDoubleHashMap(capacity);
    }

    public SparseHashedDoubleArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.data = new TIntDoubleHashMap(capacity);
    }

    @Override
    public double increment(int key, double value) {
        return this.data.adjustOrPutValue(key, value, value);
    }

    @Override
    public int[] indices() {
        return this.data.keys();
    }

    @Override
    public double[] values() {
        return this.data.values();
    }

    @Override
    public Iterable<SparseDoubleArray.Entry> entries() {
        return new Iterable<SparseDoubleArray.Entry>(){

            @Override
            public Iterator<SparseDoubleArray.Entry> iterator() {
                return new Iterator<SparseDoubleArray.Entry>(){
                    private SparseDoubleArray.Entry entry = new SparseDoubleArray.Entry();
                    private TIntDoubleIterator iterator;
                    {
                        this.iterator = SparseHashedDoubleArray.this.data.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public SparseDoubleArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.iterator.advance();
                        this.entry.index = this.iterator.key();
                        this.entry.value = this.iterator.value();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseHashedDoubleArray)) {
            return false;
        }
        return this.length == ((SparseHashedDoubleArray)obj).length && this.data.equals(((SparseHashedDoubleArray)obj).data);
    }

    @Override
    public double get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.length ^ this.data.hashCode();
    }

    @Override
    public boolean isUsed(int key) {
        return this.data.contains(key);
    }

    @Override
    public double set(int key, double value) {
        return this.data.put(key, value);
    }

    @Override
    public int used() {
        return this.data.size();
    }

    @Override
    public void compact() {
        this.data.compact();
    }

    @Override
    public SparseDoubleArray copy() {
        SparseHashedDoubleArray copy = new SparseHashedDoubleArray(this.length);
        copy.data = new TIntDoubleHashMap(this.data);
        return copy;
    }

    @Override
    public SparseDoubleArray reverse() {
        TIntDoubleHashMap tmp = new TIntDoubleHashMap(this.data.size());
        for (SparseDoubleArray.Entry e : this.entries()) {
            tmp.put(this.length - e.index, e.value);
        }
        this.data = tmp;
        return this;
    }
}

