/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseIntArray;

public class SparseHashedIntArray
extends SparseIntArray {
    TIntIntHashMap data;

    public SparseHashedIntArray(int[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseHashedIntArray(int length) {
        this(length, 10);
    }

    public SparseHashedIntArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.data = new TIntIntHashMap(capacity);
    }

    public SparseHashedIntArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.data = new TIntIntHashMap(capacity);
    }

    @Override
    public int increment(int key, int value) {
        return this.data.adjustOrPutValue(key, value, value);
    }

    @Override
    public int[] indices() {
        return this.data.keys();
    }

    @Override
    public int[] values() {
        return this.data.values();
    }

    @Override
    public Iterable<SparseIntArray.Entry> entries() {
        return new Iterable<SparseIntArray.Entry>(){

            @Override
            public Iterator<SparseIntArray.Entry> iterator() {
                return new Iterator<SparseIntArray.Entry>(){
                    private SparseIntArray.Entry entry = new SparseIntArray.Entry();
                    private TIntIntIterator iterator;
                    {
                        this.iterator = SparseHashedIntArray.this.data.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public SparseIntArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.iterator.advance();
                        this.entry.index = this.iterator.key();
                        this.entry.value = this.iterator.value();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseHashedIntArray)) {
            return false;
        }
        return this.length == ((SparseHashedIntArray)obj).length && this.data.equals(((SparseHashedIntArray)obj).data);
    }

    @Override
    public int get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.length ^ this.data.hashCode();
    }

    @Override
    public boolean isUsed(int key) {
        return this.data.contains(key);
    }

    @Override
    public int set(int key, int value) {
        return this.data.put(key, value);
    }

    @Override
    public int used() {
        return this.data.size();
    }

    @Override
    public void compact() {
        this.data.compact();
    }

    @Override
    public SparseIntArray copy() {
        SparseHashedIntArray copy = new SparseHashedIntArray(this.length);
        copy.data = new TIntIntHashMap(this.data);
        return copy;
    }

    @Override
    public SparseIntArray reverse() {
        TIntIntHashMap tmp = new TIntIntHashMap(this.data.size());
        for (SparseIntArray.Entry e : this.entries()) {
            tmp.put(this.length - e.index, e.value);
        }
        this.data = tmp;
        return this;
    }
}

