/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.hash.TIntLongHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseLongArray;

public class SparseHashedLongArray
extends SparseLongArray {
    TIntLongHashMap data;

    public SparseHashedLongArray(long[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) continue;
            this.set(i, values[i]);
        }
    }

    public SparseHashedLongArray(int length) {
        this(length, 10);
    }

    public SparseHashedLongArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.data = new TIntLongHashMap(capacity);
    }

    public SparseHashedLongArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.data = new TIntLongHashMap(capacity);
    }

    @Override
    public long increment(int key, long value) {
        return this.data.adjustOrPutValue(key, value, value);
    }

    @Override
    public int[] indices() {
        return this.data.keys();
    }

    @Override
    public long[] values() {
        return this.data.values();
    }

    @Override
    public Iterable<SparseLongArray.Entry> entries() {
        return new Iterable<SparseLongArray.Entry>(){

            @Override
            public Iterator<SparseLongArray.Entry> iterator() {
                return new Iterator<SparseLongArray.Entry>(){
                    private SparseLongArray.Entry entry = new SparseLongArray.Entry();
                    private TIntLongIterator iterator;
                    {
                        this.iterator = SparseHashedLongArray.this.data.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public SparseLongArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.iterator.advance();
                        this.entry.index = this.iterator.key();
                        this.entry.value = this.iterator.value();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseHashedLongArray)) {
            return false;
        }
        return this.length == ((SparseHashedLongArray)obj).length && this.data.equals(((SparseHashedLongArray)obj).data);
    }

    @Override
    public long get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.length ^ this.data.hashCode();
    }

    @Override
    public boolean isUsed(int key) {
        return this.data.contains(key);
    }

    @Override
    public long set(int key, long value) {
        return this.data.put(key, value);
    }

    @Override
    public int used() {
        return this.data.size();
    }

    @Override
    public void compact() {
        this.data.compact();
    }

    @Override
    public SparseLongArray copy() {
        SparseHashedLongArray copy = new SparseHashedLongArray(this.length);
        copy.data = new TIntLongHashMap(this.data);
        return copy;
    }

    @Override
    public SparseLongArray reverse() {
        TIntLongHashMap tmp = new TIntLongHashMap(this.data.size());
        for (SparseLongArray.Entry e : this.entries()) {
            tmp.put(this.length - e.index, e.value);
        }
        this.data = tmp;
        return this;
    }
}

