/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.util.tree.TreeNode;

public class TreeNodeImpl<T>
implements TreeNode<T> {
    private static final long serialVersionUID = 1L;
    public T value;
    public List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();

    public TreeNodeImpl() {
    }

    public TreeNodeImpl(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(TreeNode<T> tn) {
        this.children.add(tn);
    }

    @Override
    public void removeChild(TreeNode<T> tn) {
        this.children.remove(tn);
    }

    @Override
    public Iterator<TreeNode<T>> iterator() {
        return this.children.iterator();
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public String toString() {
        String v = "Node(" + this.value + ")[";
        for (TreeNode<T> ch : this.children) {
            v = v + ch.toString() + ", ";
        }
        return v + "]";
    }
}

