/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import org.openimaj.image.Image;
import org.openimaj.video.Video;

public abstract class AnimatedVideo<I extends Image<?, I>>
extends Video<I> {
    private I currentFrame;
    private I nextFrame;
    private double fps;

    public AnimatedVideo(I blankFrame) {
        this(blankFrame, 30.0);
    }

    public AnimatedVideo(I blankFrame, double fps) {
        this.currentFrame = blankFrame;
        this.nextFrame = ((Image)blankFrame).clone();
        this.fps = fps;
        this.init();
    }

    protected abstract void updateNextFrame(I var1);

    @Override
    public I getNextFrame() {
        this.updateNextFrame(this.nextFrame);
        I tmp = this.currentFrame;
        this.currentFrame = this.nextFrame;
        this.nextFrame = tmp;
        ++((Video)this).currentFrame;
        return this.currentFrame;
    }

    @Override
    public I getCurrentFrame() {
        return this.currentFrame;
    }

    @Override
    public int getWidth() {
        return ((Image)this.currentFrame).getWidth();
    }

    @Override
    public int getHeight() {
        return ((Image)this.currentFrame).getHeight();
    }

    @Override
    public long getTimeStamp() {
        return (long)((double)(((Video)this).currentFrame * 1000) / this.fps);
    }

    @Override
    public double getFPS() {
        return this.fps;
    }

    @Override
    public boolean hasNextFrame() {
        return true;
    }

    @Override
    public long countFrames() {
        return -1L;
    }

    @Override
    public void reset() {
        ((Video)this).currentFrame = 0;
    }

    protected void init() {
    }
}

